/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.server;

import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.Options;
import de.governikus.csl.uom.Request;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.SignedDataResponse;
import de.governikus.csl.uom.augment.AugmentRequest;
import de.governikus.csl.uom.client.CSLClientApi;
import de.governikus.csl.uom.core.SignatureRequest;
import de.governikus.csl.uom.decrypt.DecryptOptions;
import de.governikus.csl.uom.decrypt.DecryptRequest;
import de.governikus.csl.uom.decrypt.DecryptedDataResponse;
import de.governikus.csl.uom.decrypt.impl.DecryptRequestImpl;
import de.governikus.csl.uom.hash.HashRequest;
import de.governikus.csl.uom.hash.HashResponse;
import de.governikus.csl.uom.jce.CSLCryptoProvider;
import de.governikus.csl.uom.res.Resource;
import de.governikus.csl.uom.res.ResourceReferenceParameter;
import de.governikus.csl.uom.res.ResourcesUtil;
import de.governikus.csl.uom.res.management.ResourceManager;
import de.governikus.csl.uom.server.CSLServerApi;
import de.governikus.csl.uom.server.CSLServerApiException;
import de.governikus.csl.uom.sign.SignOptions;
import de.governikus.csl.uom.sign.SignRequest;
import de.governikus.csl.uom.sign.SignerInfo;
import de.governikus.csl.uom.tsp.TimestampRequest;
import de.governikus.csl.uom.tsp.TimestampResponse;
import de.governikus.csl.uom.util.Environment;
import de.governikus.csl.uom.validate.ObjectValidationResult;
import de.governikus.csl.uom.validate.ValidateOptions;
import de.governikus.csl.uom.validate.ValidateRequest;
import de.governikus.csl.uom.validate.ValidateResponse;
import java.io.Closeable;
import java.security.Provider;
import java.security.Security;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class CSLServerApiImpl
implements CSLServerApi {
    private final CSLClientApi cslClientApi;
    private final ResourceManager resourceManager;

    public CSLServerApiImpl(ResourceManager resourceManager, CSLClientApi cslClientApi) throws CSLServerApiException {
        if (resourceManager == null) {
            throw new CSLServerApiException(CSLServerApiException.Failure.PREPARE, "ResourceManager instance can not be null");
        }
        if (cslClientApi == null) {
            throw new CSLServerApiException(CSLServerApiException.Failure.PREPARE, "CSLClientApi instance can not be null");
        }
        this.resourceManager = resourceManager;
        this.cslClientApi = cslClientApi;
        if (Security.getProvider("CPP") == null) {
            Security.addProvider((Provider)new CSLCryptoProvider());
        }
    }

    public SignedDataResponse sign(SignRequest signRequest, Environment env) throws CoreException {
        try {
            Set<Resource> resources = null;
            try {
                resources = this.allocateResources((Request<?, ?>)signRequest);
            }
            catch (CoreException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CSLServerApiException(CSLServerApiException.Failure.PREPARE, e);
            }
            finally {
                this.releaseResources(resources);
            }
            SignatureRequest signRequestWithResources = null;
            try {
                SignOptions options = (SignOptions)signRequest.getOptions();
                if (options == null) {
                    throw new CSLServerApiException(CSLServerApiException.Failure.PREPARE, "no sign options specified or configured");
                }
                Set signerInfos = options.getSignerInfos();
                if (signerInfos == null || signerInfos.isEmpty()) {
                    throw new CSLServerApiException(CSLServerApiException.Failure.PREPARE, "no sign infos specified or configured");
                }
                if (((SignerInfo)signerInfos.iterator().next()).getKey() == null) {
                    throw new CSLServerApiException(CSLServerApiException.Failure.PREPARE, "no signer key specified or configured");
                }
                ResourcesUtil.replaceReferencesWithResources((SignRequest)signRequest, resources);
                SignOptions resourcesOptions = (SignOptions)signRequest.getOptions();
                signRequestWithResources = new SignatureRequest(resourcesOptions, signRequest.getDataToBeSigned());
            }
            catch (CoreException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CSLServerApiException(CSLServerApiException.Failure.PREPARE, e);
            }
            finally {
                this.releaseResources(resources);
            }
            return this.sign(env, resources, (SignRequest)signRequestWithResources);
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CSLServerApiException(CSLServerApiException.Failure.PROCESSING_FAILED, e);
        }
    }

    private SignedDataResponse sign(Environment env, Set<Resource> resources, SignRequest signRequestWithResources) throws CoreException, CSLServerApiException {
        try {
            SignedDataResponse signedDataResponse = this.cslClientApi.sign(signRequestWithResources, env);
            return signedDataResponse;
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CSLServerApiException(CSLServerApiException.Failure.PROCESSING_FAILED, e);
        }
        finally {
            this.releaseResources(resources);
        }
    }

    private void releaseResources(Set<Resource> resources) {
        if (resources == null || resources.isEmpty()) {
            return;
        }
        this.resourceManager.releaseResources(resources);
    }

    private Set<Resource> allocateResources(Request<?, ?> uRequest) throws CoreException {
        Options options = uRequest.getOptions();
        if (options instanceof SignOptions) {
            ResourceReferenceParameter resourceReference;
            SignOptions signOptions = (SignOptions)options;
            Set resourceReferences = ResourcesUtil.findResourceReferences((SignOptions)signOptions);
            boolean allResourceWithReference = true;
            Iterator iterator = resourceReferences.iterator();
            while (iterator.hasNext() && (allResourceWithReference &= Resource.class.isInstance(resourceReference = (ResourceReferenceParameter)iterator.next()))) {
            }
            if (allResourceWithReference) {
                HashSet<Resource> result = new HashSet<Resource>();
                for (ResourceReferenceParameter resourceReference2 : resourceReferences) {
                    result.add((Resource)resourceReference2);
                }
                return result;
            }
            return this.resourceManager.allocateResources(resourceReferences);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashResponse hash(HashRequest request, Environment env) throws CoreException {
        Set<Resource> resources = this.allocateResources((Request<?, ?>)request);
        try {
            HashResponse hashResponse = this.cslClientApi.hash(request, env);
            return hashResponse;
        }
        finally {
            this.releaseResources(resources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignedDataResponse augment(AugmentRequest request) throws CoreException {
        Set<Resource> resources = this.allocateResources((Request<?, ?>)request);
        try {
            SignedDataResponse signedDataResponse = this.cslClientApi.augment(request);
            return signedDataResponse;
        }
        finally {
            this.releaseResources(resources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimestampResponse timestamp(TimestampRequest timestampRequest, Closeable transportClient, Environment env) throws CoreException {
        Set<Resource> resources = this.allocateResources((Request<?, ?>)timestampRequest);
        try {
            TimestampResponse timestampResponse = this.cslClientApi.timestamp(timestampRequest, transportClient, env);
            return timestampResponse;
        }
        finally {
            this.releaseResources(resources);
        }
    }

    public ObjectValidationResult validate(SignedData sda, ValidateOptions options) throws CoreException {
        return this.cslClientApi.validate(sda, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidateResponse validate(ValidateRequest validateRequest) throws CoreException {
        Set<Resource> resources = this.allocateResources((Request<?, ?>)validateRequest);
        try {
            ValidateResponse validateResponse = this.cslClientApi.validate(validateRequest);
            return validateResponse;
        }
        finally {
            this.releaseResources(resources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DecryptedDataResponse decrypt(DecryptRequest decryptRequest, Environment env) throws CoreException {
        Set<Resource> resources = this.allocateResources((Request<?, ?>)decryptRequest);
        try {
            DecryptOptions options = (DecryptOptions)decryptRequest.getOptions();
            if (options == null) {
                throw new IllegalArgumentException("no decrypt options specified or configured");
            }
            ResourcesUtil.replaceReferencesWithResources((DecryptRequest)decryptRequest, resources);
            DecryptOptions resourcesOptions = (DecryptOptions)decryptRequest.getOptions();
            DecryptRequestImpl decryptRequestWithResources = new DecryptRequestImpl(resourcesOptions, decryptRequest.getDataToBeDecrypted());
            DecryptedDataResponse decryptedDataResponse = this.cslClientApi.decrypt((DecryptRequest)decryptRequestWithResources, env);
            return decryptedDataResponse;
        }
        finally {
            this.releaseResources(resources);
        }
    }
}

