/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.sign.props;

import de.governikus.csl.sign.props.ConverterEncodingDivider;
import de.governikus.csl.sign.props.SelfProcessingSignPropertiesEncoder;
import de.governikus.csl.sign.props.SignPropertiesConverter;
import de.governikus.csl.uom.sign.ConstraintSignPolicy;
import de.governikus.csl.uom.sign.SignOptions;
import de.governikus.csl.uom.sign.SignPolicy;
import de.governikus.csl.uom.sign.SignProperty;
import de.governikus.csl.uom.sign.SignRequest;
import de.governikus.csl.uom.sign.SigningContext;
import de.governikus.csl.uom.sign.impl.EncodingConstraintHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSignPropertiesConverterManager<E, C extends SigningContext>
implements SignPropertiesConverter<SignProperty, E, C> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSignPropertiesConverterManager.class);
    private final Class<C> cacheClass;
    protected final Map<String, SignPropertiesConverter<? extends SignProperty, ? extends E, C>> decoderMap;
    private final Class<E> encodedClass;
    private final Map<String, SignPropertiesConverter<? extends SignProperty, ? extends E, C>> encoderMap;
    protected final List<Object> processedReturnNullInstances;

    private static String createVersionSuffix(ConstraintSignPolicy.EncodingConstraint encoding) {
        return AbstractSignPropertiesConverterManager.createVersionSuffix(encoding.name());
    }

    protected static String createVersionSuffix(String version) {
        return "-" + version;
    }

    public AbstractSignPropertiesConverterManager(Class<E> encodedClass, Class<C> cacheClass) {
        this.encodedClass = encodedClass;
        this.cacheClass = cacheClass;
        this.encoderMap = Collections.synchronizedMap(new LinkedHashMap());
        this.decoderMap = Collections.synchronizedMap(new LinkedHashMap());
        this.processedReturnNullInstances = new ArrayList<Object>();
    }

    protected void add(List<SignPropertiesConverter<? extends SignProperty, ? extends E, C>> converters) {
        LOG.debug("adding converters");
        for (SignPropertiesConverter<SignProperty, E, C> signPropertiesConverter : converters) {
            for (ConstraintSignPolicy.EncodingConstraint encoding : signPropertiesConverter.getEncodings()) {
                String key = signPropertiesConverter.getDecodedClass().getName() + AbstractSignPropertiesConverterManager.createVersionSuffix(encoding);
                String converterClassname = signPropertiesConverter.getClass().getName();
                if (this.encoderMap.containsKey(key)) {
                    throw new IllegalArgumentException("two converter specified: " + key + ", registered first: " + this.encoderMap.get(key).getClass().getName() + ", second converter: " + converterClassname);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("adding converter: " + key + " - " + converterClassname);
                }
                this.encoderMap.put(key, signPropertiesConverter);
            }
            if (signPropertiesConverter instanceof SelfProcessingSignPropertiesEncoder) {
                LOG.debug("converter working standalone");
                this.processedReturnNullInstances.add(((SelfProcessingSignPropertiesEncoder)((Object)signPropertiesConverter)).getProcessedReturnNullInstance());
            }
            if (!signPropertiesConverter.useDefaultEncodings()) continue;
            LOG.debug("converter is used for default encoding");
            String versionSuffix = signPropertiesConverter instanceof ConverterEncodingDivider ? AbstractSignPropertiesConverterManager.createVersionSuffix(((ConverterEncodingDivider)((Object)signPropertiesConverter)).getDivider()) : "";
            this.decoderMap.put(signPropertiesConverter.getEncodedClass().getName() + versionSuffix, signPropertiesConverter);
        }
    }

    public <T extends E, S extends SignProperty> S decode(Class<S> typeClass, T encodedProperty) throws IOException {
        if (typeClass == null) {
            return null;
        }
        return (S)((SignProperty)typeClass.cast(this.decode(encodedProperty)));
    }

    @Override
    public <T extends E> SignProperty decode(T encodedProperty) throws IOException {
        if (encodedProperty == null) {
            return null;
        }
        SignPropertiesConverter<SignProperty, E, C> adESPropertiesConverter = this.decoderMap.get(encodedProperty.getClass().getName());
        if (adESPropertiesConverter == null) {
            throw new RuntimeException("decoding converter not available: " + encodedProperty);
        }
        if (adESPropertiesConverter.getEncodedClass().isInstance(encodedProperty)) {
            return adESPropertiesConverter.decode(encodedProperty);
        }
        return null;
    }

    @Override
    public final <T extends E> T encode(Class<T> typeClass, SignProperty signProperty) throws IOException {
        if (typeClass == null) {
            return null;
        }
        return typeClass.cast(this.encode(signProperty, (C)null));
    }

    @Override
    public final E encode(SignProperty signProperty, C cache) throws IOException {
        String[] basenames;
        if (signProperty == null) {
            return null;
        }
        LOG.debug("encoding sign property: " + signProperty);
        for (String basename : basenames = new String[]{signProperty.getClass().getName(), signProperty.getClass().getSuperclass().getName()}) {
            E result;
            if (LOG.isDebugEnabled()) {
                LOG.debug("encoding property using basename: " + basename);
            }
            if ((result = this.encodeInt(basename, signProperty, cache)) != null && this.processedReturnNullInstances.contains(result)) {
                LOG.debug("converter working standalone - returning null");
                return null;
            }
            if (result == null) continue;
            return result;
        }
        throw new RuntimeException("encoding converter not available: " + signProperty + "(" + signProperty.getEncodings() + ")");
    }

    private E encodeInt(String basename, SignProperty signProperty, C cache) throws IOException {
        List encodings = EncodingConstraintHelper.buildEncodingConstraints((SignPolicy)this.getPolicy(cache), (SignProperty)signProperty);
        LOG.debug("finding matching converter for property");
        for (ConstraintSignPolicy.EncodingConstraint encoding : encodings) {
            SignPropertiesConverter<SignProperty, E, C> adESPropertiesConverter;
            if (LOG.isDebugEnabled()) {
                LOG.debug("find matching converter for encoding: " + encoding);
            }
            String key = basename + AbstractSignPropertiesConverterManager.createVersionSuffix(encoding);
            if (LOG.isDebugEnabled()) {
                LOG.debug("key: " + key);
            }
            if ((adESPropertiesConverter = this.encoderMap.get(key)) == null || !adESPropertiesConverter.getDecodedClass().isInstance(signProperty)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("matching converter found: " + adESPropertiesConverter);
            }
            return adESPropertiesConverter.encode((SignProperty)signProperty, cache);
        }
        return null;
    }

    private SignPolicy getPolicy(C cache) {
        if (cache == null) {
            return null;
        }
        SignRequest signRequest = cache.getSignRequest();
        if (signRequest == null) {
            return null;
        }
        SignOptions signOptions = (SignOptions)signRequest.getOptions();
        if (signOptions == null) {
            return null;
        }
        return (SignPolicy)signOptions.getPolicy();
    }

    @Override
    public final Class<C> getCacheClass() {
        return this.cacheClass;
    }

    @Override
    public final Class<SignProperty> getDecodedClass() {
        return SignProperty.class;
    }

    @Override
    public final Class<E> getEncodedClass() {
        return this.encodedClass;
    }

    public final List<ConstraintSignPolicy.EncodingConstraint> getEncodings() {
        return ConstraintSignPolicy.EncodingConstraint.DEFAULT;
    }

    public final boolean useDefaultEncodings() {
        return true;
    }
}

