/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.sign.impl;

import de.governikus.csl.sign.DetachedSignedDocumentWithContentDocument;
import de.governikus.csl.sign.SignedDocument;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.ReferenceResolver;
import de.governikus.csl.uom.jcebase.XMLOIDJCEAlgorithmMapper;
import de.governikus.csl.uom.sign.SignatureType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;

public class DetachedSignedDocumentWithContentDocumentImpl<P>
implements DetachedSignedDocumentWithContentDocument<P> {
    private final Document contentDocument;
    private final SignedDocument<P> detachedSignatureDocument;

    public DetachedSignedDocumentWithContentDocumentImpl(SignedDocument<P> detachedSignatureDocument, Document contentDocument) {
        this.detachedSignatureDocument = Objects.requireNonNull(detachedSignatureDocument, "signature document is required");
        if (SignatureType.DETACHED != this.detachedSignatureDocument.getSignatureType()) {
            throw new IllegalArgumentException("detached signature document is required: " + this.detachedSignatureDocument.getSignatureType());
        }
        this.contentDocument = contentDocument;
        DetachedSignedDocumentWithContentDocumentImpl.checkDocumentPair(this.detachedSignatureDocument, this.contentDocument);
    }

    public static void checkDocumentPair(SignedDocument<?> detachedSignatureDocument, Document document) {
        if (detachedSignatureDocument == null) {
            throw new IllegalArgumentException("illegal detached signature document");
        }
        if (document == null) {
            return;
        }
        if (!DetachedSignedDocumentWithContentDocumentImpl.isValidDocumentPair(detachedSignatureDocument, document)) {
            throw new IllegalArgumentException("illegal content document not matching to detached signature document");
        }
    }

    private static boolean isValidDocumentPair(SignedDocument<?> detachedSignatureDocument, Document document) {
        MessageDigest messageDigest;
        String digestAlgorithmURI = DetachedSignedDocumentWithContentDocumentImpl.checkDigestAlgorithmURI(detachedSignatureDocument);
        byte[] contentMessageDigest = DetachedSignedDocumentWithContentDocumentImpl.checkDigestValue(detachedSignatureDocument);
        String jceDigestAlgorithm = XMLOIDJCEAlgorithmMapper.getMapper().mapXMLAlgorithmJCE(digestAlgorithmURI);
        try {
            messageDigest = MessageDigest.getInstance(jceDigestAlgorithm, "BC");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new IllegalArgumentException("failed to create digest instance: " + jceDigestAlgorithm, e);
        }
        try (DigestInputStream is = new DigestInputStream(document.getInputStream(), messageDigest);){
            IOUtils.copy((InputStream)is, (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("failed to read document for calculating digest", e);
        }
        return MessageDigest.isEqual(contentMessageDigest, messageDigest.digest());
    }

    public static byte[] checkDigestValue(SignedDocument<?> detachedSignatureDocument) {
        if (detachedSignatureDocument == null) {
            throw new IllegalArgumentException();
        }
        byte[] contentMessageDigest = detachedSignatureDocument.getContentDocumentDigestValue();
        if (contentMessageDigest == null || contentMessageDigest.length == 0) {
            throw new IllegalArgumentException("detached signature document must provide content digest value");
        }
        return contentMessageDigest;
    }

    public static String checkDigestAlgorithmURI(SignedDocument<?> detachedSignatureDocument) {
        if (detachedSignatureDocument == null) {
            throw new IllegalArgumentException();
        }
        String digestAlgorithmURI = detachedSignatureDocument.getDigestAlgorithmURI();
        if (digestAlgorithmURI == null || digestAlgorithmURI.isEmpty()) {
            throw new IllegalArgumentException("detached signature document must provide URI of digest algorithm");
        }
        return digestAlgorithmURI;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.detachedSignatureDocument.hashCode();
        result = 31 * result + (this.contentDocument == null ? 0 : this.contentDocument.hashCode());
        return result;
    }

    public String toString() {
        return "DetachedSignedDocumentWithContentDocumentImpl[detachedSignatureDocument=" + this.detachedSignatureDocument + ", document=" + this.contentDocument + "]@" + this.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DetachedSignedDocumentWithContentDocumentImpl other = (DetachedSignedDocumentWithContentDocumentImpl)obj;
        if (this.contentDocument == null ? other.contentDocument != null : !this.contentDocument.equals(other.contentDocument)) {
            return false;
        }
        return this.detachedSignatureDocument.equals(other.detachedSignatureDocument);
    }

    public InputStream getInputStream() throws IOException {
        return this.detachedSignatureDocument.getInputStream();
    }

    public String getName() {
        return this.detachedSignatureDocument.getName();
    }

    public String getContentType() {
        return this.detachedSignatureDocument.getContentType();
    }

    public P getParsed() {
        return (P)this.detachedSignatureDocument.getParsed();
    }

    public String getId() {
        return this.detachedSignatureDocument.getId();
    }

    public ReferenceResolver getReferenceResolver() {
        return this.detachedSignatureDocument.getReferenceResolver();
    }

    @Override
    public SignatureType getSignatureType() {
        return this.detachedSignatureDocument.getSignatureType();
    }

    @Override
    public String getDigestAlgorithmURI() {
        return this.detachedSignatureDocument.getDigestAlgorithmURI();
    }

    @Override
    public byte[] getContentDocumentDigestValue() {
        return this.detachedSignatureDocument.getContentDocumentDigestValue();
    }

    @Override
    public Document getContentDocument() {
        return this.contentDocument;
    }
}

