/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.sign.impl;

import de.governikus.csl.sign.CSLSignatureException;
import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.DataToBeSigned;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.InstanceProvider;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.PluginType;
import de.governikus.csl.uom.RequestProcessor;
import de.governikus.csl.uom.impl.AbstractPlugin;
import de.governikus.csl.uom.jce.CSLCryptoProvider;
import de.governikus.csl.uom.sign.SignOptions;
import de.governikus.csl.uom.sign.SignPlugin;
import de.governikus.csl.uom.sign.SignRequest;
import de.governikus.csl.uom.sign.SignerInfo;
import de.governikus.csl.uom.sign.impl.CounterSignerInfo;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class AbstractSignPlugin
extends AbstractPlugin
implements SignPlugin {
    private InstanceProvider instanceProvider;
    private final List<Class<? extends Document>> documentOutputClasses;

    public static CSLSignatureException handleUnknownExceptions(CSLSignatureException.Failure signingFailure, String prefix, Exception e) {
        return new CSLSignatureException(signingFailure, "failed to " + (CSLSignatureException.Failure.SIGNING_PREPARE == signingFailure ? "prepare " : "") + (String)(prefix == null ? "" : prefix + " ") + "sign with not expected exception: " + e.getMessage(), e);
    }

    public AbstractSignPlugin(List<Class<? extends Document>> documentOutputClasses) throws CSLSignatureException {
        if (Security.getProvider("CPP") == null) {
            Security.addProvider((Provider)new CSLCryptoProvider());
        }
        if (documentOutputClasses == null) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "plugin must support at least one Document implementation, null invalid");
        }
        if (documentOutputClasses.isEmpty()) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "plugin must support at least one Document implementation, empty list invalid");
        }
        this.documentOutputClasses = Collections.unmodifiableList(new ArrayList<Class<? extends Document>>(documentOutputClasses));
    }

    public synchronized void initialize(InstanceProvider instanceProvider) {
        this.instanceProvider = instanceProvider;
    }

    public boolean isMultipleSignedDataPlugin() {
        return false;
    }

    public static SignRequest checkSignRequest(SignRequest signRequest) throws CSLSignatureException {
        if (signRequest == null) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "signing without valid request not possible");
        }
        List datasToBeSigned = signRequest.getDataToBeSigned();
        if (datasToBeSigned == null || datasToBeSigned.size() != 1) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "only one signed data at request supported for signing");
        }
        DataToBeSigned dataToBeSigned = (DataToBeSigned)datasToBeSigned.get(0);
        if (dataToBeSigned == null) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "data to be signed can not be null");
        }
        List documents = dataToBeSigned.getDocuments();
        if (documents == null || documents.isEmpty()) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "documents to be signed can not be null or empty");
        }
        SignOptions signOptions = (SignOptions)signRequest.getOptions();
        if (signOptions == null) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "SignOptions can not be null");
        }
        Set signerInfos = signOptions.getSignerInfos();
        if (signerInfos == null || signerInfos.isEmpty()) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "signer infos can not be null or empty");
        }
        for (SignerInfo signerInfo : signerInfos) {
            if (signerInfo.getKey() != null) continue;
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "referenced key of SignerInfo can not be null");
        }
        return signRequest;
    }

    public static boolean allCounterSignerInfo(SignOptions options) throws CSLSignatureException {
        Class<?> tmpclass = null;
        for (SignerInfo signerInfo : options.getSignerInfos()) {
            if (tmpclass == null) {
                tmpclass = signerInfo.getClass();
            }
            if (tmpclass.equals(signerInfo.getClass())) continue;
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "inconsistent type of signer infos, at least two different types are used: " + tmpclass + " and " + signerInfo.getClass());
        }
        return CounterSignerInfo.class.equals(tmpclass);
    }

    public final RequestProcessor getProcessor(Class<? extends RequestProcessor> processorType, RequestProcessor.ProcessorID id) throws Exception {
        return this.instanceProvider.getRequestProcessor(id, processorType, null);
    }

    public List<Class<? extends Document>> getDocumentOutputClasses() {
        return this.documentOutputClasses;
    }

    public InstanceProvider getManagerService() {
        return this.instanceProvider;
    }

    public static SignPlugin assertSignPlugin(SignPlugin signPlugin, Plugin.PluginID requiredPluginID) throws CSLSignatureException {
        if (requiredPluginID == null) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "SignPlugin cannot checked without expected PluginID value, PluginID is null, not null value is required");
        }
        if (signPlugin == null) {
            return null;
        }
        PluginType annotation = signPlugin.getClass().getAnnotation(PluginType.class);
        if (annotation == null) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "SignPlugin instance missing required PluginType annotation");
        }
        if (!SignPlugin.class.equals((Object)annotation.type())) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "PluginType annotation of SignPlugin instance requires expected type SignPlugin.class, found annoation type value: " + annotation.type());
        }
        if (requiredPluginID != annotation.id()) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "PluginType annotation of SignPlugin instance requires expected ID " + requiredPluginID + ", found annotation id value: " + annotation.id());
        }
        return signPlugin;
    }

    protected SignPlugin getAssertedSignPlugin(Plugin.PluginID pluginID) throws CSLSignatureException, CoreException {
        return AbstractSignPlugin.assertSignPlugin(this.getSignPlugin(pluginID), pluginID);
    }

    protected SignPlugin getSignPlugin(Plugin.PluginID pluginID) throws CSLSignatureException, CoreException {
        if (this.getManagerService() == null) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_PREPARE, "finding and creating a SignPlugin requires missing instance provider");
        }
        try {
            return (SignPlugin)this.getManagerService().getNotNullPlugin(pluginID, SignPlugin.class);
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CSLSignatureException(CSLSignatureException.Failure.SIGNING_FAILED, "finding and creating a SignPlugin instance to sign CMS/XML failed: " + e.getMessage());
        }
    }
}

