/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.sign.doc;

import de.bos_bremen.algorithm_identifier.AlgorithmService;
import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.governikus.csl.sign.doc.DigestDocument;
import de.governikus.csl.uom.ReferenceResolver;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDigestDocument
implements DigestDocument {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDigestDocument.class);
    protected final String name;
    protected final String digestAlgorithmURI;
    protected final byte[] digestValue;

    protected AbstractDigestDocument(AbstractDigestDocument copy) throws NullPointerException {
        this(Objects.requireNonNull(copy).name, copy.digestAlgorithmURI, copy.digestValue);
    }

    protected AbstractDigestDocument(String name, String digestAlgorithmURI, byte[] digestValue) throws IllegalArgumentException {
        this.name = Objects.requireNonNull(name);
        if (digestAlgorithmURI == null && digestValue != null) {
            throw new IllegalArgumentException("URI of digest algorithm can not be null, when digest value is not null");
        }
        if (digestAlgorithmURI != null && digestValue == null) {
            throw new IllegalArgumentException("digest value can not be null, when URI of digest algorithm is not null");
        }
        this.digestAlgorithmURI = digestAlgorithmURI;
        if (digestAlgorithmURI != null) {
            if (digestAlgorithmURI.isEmpty()) {
                throw new IllegalArgumentException("URI of digest algorithm can not be empty");
            }
            if (digestValue.length == 0) {
                throw new IllegalArgumentException("digest value can not be an empty byte[] array");
            }
            this.digestValue = new byte[digestValue.length];
            DigestAlgorithm digestAlgorithm = AlgorithmService.getDigestForAny((String)digestAlgorithmURI);
            if (digestAlgorithm == null) {
                throw new IllegalArgumentException("digest algorithm unknown for AlgorithmIdentifier: " + digestAlgorithmURI);
            }
            int validDigestSize = digestAlgorithm.getDigestSize();
            if (validDigestSize != digestValue.length) {
                throw new IllegalArgumentException("size of digest value not matching digest algorithm: " + digestValue.length + ", valid/expected digest length: " + validDigestSize);
            }
            System.arraycopy(digestValue, 0, this.digestValue, 0, digestValue.length);
        } else {
            this.digestValue = digestValue;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("external digest document created");
        }
    }

    public final String getName() {
        return this.name;
    }

    public final String getContentType() {
        return "application/binary";
    }

    public final String getId() {
        return this.name;
    }

    public final ReferenceResolver getReferenceResolver() {
        return null;
    }

    @Override
    public final byte[] getDigestValue() {
        return this.digestValue;
    }

    @Override
    public final String getDigestAlgorithmURI() {
        return this.digestAlgorithmURI;
    }
}

