/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.sign.auth.impl;

import de.governikus.csl.sign.auth.Range;

public class RangeImpl<N extends Number>
implements Range<N> {
    protected final N maximum;
    protected final N minimum;

    public RangeImpl() {
        this(null, null);
    }

    public RangeImpl(N maximum) {
        this(maximum, null);
    }

    public RangeImpl(N maximum, N minimum) throws IllegalArgumentException {
        if (maximum != null && minimum != null && ((Comparable)maximum).compareTo(minimum) < 0) {
            throw new IllegalArgumentException("maximum must be greater equals than minimum");
        }
        this.maximum = maximum;
        this.minimum = minimum;
    }

    @Override
    public final N getMinimum() {
        return this.minimum;
    }

    @Override
    public N getMaximum() {
        return this.maximum;
    }

    @Override
    public boolean isValid(N value) {
        if (value == null) {
            return true;
        }
        if (this.minimum == null && this.maximum == null) {
            return true;
        }
        if (this.minimum != null && ((Comparable)this.minimum).compareTo(value) > 0) {
            return false;
        }
        return this.maximum == null || ((Comparable)this.maximum).compareTo(value) >= 0;
    }
}

