/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.sign.auth.impl;

import de.governikus.csl.sign.auth.AuthenticationController;
import de.governikus.csl.sign.auth.AuthenticationControllerCreator;
import de.governikus.csl.sign.auth.AuthenticationControllerCreatorInfo;
import de.governikus.csl.sign.auth.AuthenticationControllerProvider;
import de.governikus.csl.sign.auth.impl.AuthenticationControllerCreatorInfoImpl;
import java.util.HashMap;
import java.util.Map;

public class DefaultAuthenticationControllerProvider
implements AuthenticationControllerProvider {
    private final Map<AuthenticationControllerCreatorInfo<?, ?>, AuthenticationControllerCreator<?, ?>> mapCreators = new HashMap();

    public void register(AuthenticationControllerCreator<?, ?> creator) {
        if (creator == null) {
            return;
        }
        this.mapCreators.put(creator.getInfo(), creator);
    }

    public void unregister(AuthenticationControllerCreator<?, ?> creator) {
        if (creator == null) {
            return;
        }
        this.unregister(creator.getInfo());
    }

    public void unregister(AuthenticationControllerCreatorInfo<?, ?> creatorInfo) {
        this.mapCreators.remove(creatorInfo);
    }

    public <OTA, A> AuthenticationController<OTA, A> createController(OTA objectToAuthenticate, Class<A> authenticationClass) throws IllegalStateException {
        AuthenticationControllerCreator<?, ?> controllerCreator = this.mapCreators.get(new AuthenticationControllerCreatorInfoImpl(objectToAuthenticate.getClass(), authenticationClass));
        if (controllerCreator == null) {
            throw new IllegalStateException("no controller creator registered");
        }
        return controllerCreator.createController();
    }
}

