/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.sign.auth.impl;

import de.governikus.csl.sign.auth.AuthenticationDurationMode;
import de.governikus.csl.sign.auth.AuthenticationIdentifier;
import de.governikus.csl.sign.auth.AuthenticationInputMode;
import de.governikus.csl.sign.auth.AuthenticationState;
import de.governikus.csl.sign.auth.DefaultList;
import de.governikus.csl.sign.auth.DefaultRange;
import de.governikus.csl.sign.auth.Range;
import de.governikus.csl.sign.auth.impl.RangeImpl;

public class AuthenticationIdentifierImpl
implements AuthenticationIdentifier {
    private final String name;
    private final Range<Integer> leftRetries;
    private final AuthenticationState state;
    private DefaultList<AuthenticationDurationMode> durationMode;
    private DefaultRange<Long> duration;
    private DefaultRange<Long> timeout;
    private DefaultRange<Long> secondTimeout;
    private DefaultList<AuthenticationInputMode> inputMode;

    public AuthenticationIdentifierImpl(String name) throws IllegalArgumentException {
        this(name, AuthenticationState.UNKNOWN, null);
    }

    public AuthenticationIdentifierImpl(String name, AuthenticationState state) throws IllegalArgumentException {
        this(name, state, null);
    }

    public AuthenticationIdentifierImpl(String name, AuthenticationState state, Range<Integer> leftRetries) throws IllegalArgumentException {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name can be null ot empty");
        }
        if (state == null) {
            throw new IllegalArgumentException("state can be null");
        }
        this.name = name;
        this.state = state;
        this.leftRetries = leftRetries == null ? new RangeImpl() : leftRetries;
    }

    @Override
    public DefaultRange<Long> getDuration() {
        return this.duration;
    }

    @Override
    public DefaultList<AuthenticationDurationMode> getDurationMode() {
        return this.durationMode;
    }

    @Override
    public DefaultList<AuthenticationInputMode> getInputMode() {
        return this.inputMode;
    }

    @Override
    public Range<Integer> getLeftRetries() {
        return this.leftRetries;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DefaultRange<Long> getSecondTimeout() {
        return this.secondTimeout;
    }

    @Override
    public AuthenticationState getState() {
        return this.state;
    }

    @Override
    public DefaultRange<Long> getTimeout() {
        return this.timeout;
    }

    public AuthenticationIdentifierImpl setTimeout(DefaultRange<Long> timeout) {
        this.timeout = timeout;
        return this;
    }

    public AuthenticationIdentifierImpl setSecondTimeout(DefaultRange<Long> secondTimeout) {
        this.secondTimeout = secondTimeout;
        return this;
    }

    public AuthenticationIdentifierImpl setDuration(DefaultList<AuthenticationDurationMode> durationMode, DefaultRange<Long> durationAmount) {
        return this;
    }

    @Override
    public synchronized AuthenticationIdentifier cloneUnmodifiable() {
        AuthenticationIdentifierImpl result = new AuthenticationIdentifierImpl(this.name, this.state, this.leftRetries);
        result.inputMode = (DefaultList)this.inputMode.cloneUnmodifiable();
        result.timeout = this.timeout == null ? null : (DefaultRange)this.timeout.cloneUnmodifiable();
        result.secondTimeout = this.secondTimeout == null ? null : (DefaultRange)this.secondTimeout.cloneUnmodifiable();
        result.durationMode = this.durationMode == null ? null : (DefaultList)this.durationMode.cloneUnmodifiable();
        result.duration = this.duration == null ? null : (DefaultRange)this.duration.cloneUnmodifiable();
        return result;
    }
}

