/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.sign.auth.impl;

import de.governikus.csl.sign.auth.AuthenticationConfiguration;
import de.governikus.csl.sign.auth.AuthenticationIdentifier;
import de.governikus.csl.sign.auth.AuthenticationPurpose;
import de.governikus.csl.sign.auth.DefaultList;
import java.security.cert.Certificate;

public class AuthenticationConfigurationImpl
implements AuthenticationConfiguration {
    private final AuthenticationPurpose purpose;
    private final Certificate certificate;
    private final DefaultList<String> options;
    private final DefaultList<AuthenticationIdentifier> authenticationIdentifiers;

    public AuthenticationConfigurationImpl(DefaultList<AuthenticationIdentifier> authenticationIdentifiers, AuthenticationPurpose purpose, Certificate certificate, DefaultList<String> options) throws IllegalArgumentException {
        if (authenticationIdentifiers == null || authenticationIdentifiers.isEmpty()) {
            throw new IllegalArgumentException("authenticationIdentifiers can not be null or empty");
        }
        if (purpose == null) {
            throw new IllegalArgumentException("purpose can not be null");
        }
        this.authenticationIdentifiers = authenticationIdentifiers;
        this.purpose = purpose;
        this.certificate = certificate;
        this.options = options;
    }

    @Override
    public DefaultList<AuthenticationIdentifier> getAuthenficationIdentifiers() {
        return this.authenticationIdentifiers;
    }

    @Override
    public AuthenticationPurpose getPurpose() {
        return this.purpose;
    }

    @Override
    public Certificate getAuthenticationCertificate() {
        return this.certificate;
    }

    @Override
    public DefaultList<String> getOptions() {
        return this.options;
    }

    @Override
    public AuthenticationConfiguration cloneUnmodifiable() {
        return new AuthenticationConfigurationImpl((DefaultList)this.authenticationIdentifiers.cloneUnmodifiable(), this.purpose, this.certificate, (DefaultList)this.options.cloneUnmodifiable());
    }
}

