/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.sig_val_report.sigattributes;

import de.governikus.csl.sig_val_report.ReportCreationContext;
import de.governikus.csl.sig_val_report.ReportUtil;
import de.governikus.csl.sig_val_report.sigattributes.SVPSigAttributeToSVRTransformer;
import de.governikus.csl.uom.validate.SignatureValidationResult;
import de.governikus.csl.validate.svp.TimeStampValidationDataType;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.etsi.uri._19102.v1_2_2.AttributeBaseType;
import org.etsi.uri._19102.v1_2_2.ObjectFactory;
import org.etsi.uri._19102.v1_2_2.VOReferenceType;

public class TimeStampValidationDataTypeTransformer
implements SVPSigAttributeToSVRTransformer {
    private final ObjectFactory svrFactory;
    private SVPSigAttributeToSVRTransformer nextTransformer;

    public TimeStampValidationDataTypeTransformer(ObjectFactory svrFactory) {
        this.svrFactory = svrFactory;
    }

    @Override
    public SVPSigAttributeToSVRTransformer append(SVPSigAttributeToSVRTransformer next) {
        this.nextTransformer = next;
        return next;
    }

    @Override
    public JAXBElement<?> transform(JAXBElement<? extends de.governikus.csl.validate.svp.AttributeBaseType> attrToTransform, SignatureValidationResult signatureValidationResult, ReportCreationContext reportContext) {
        JAXBElement result = null;
        if (attrToTransform.getDeclaredType() == TimeStampValidationDataType.class) {
            TimeStampValidationDataType svpTstValidationData = (TimeStampValidationDataType)attrToTransform.getValue();
            AttributeBaseType svrTimeStampValidationData = this.svrFactory.createAttributeBaseType();
            svrTimeStampValidationData.setSigned(svpTstValidationData.isSigned());
            for (byte[] tstValidationDataBytes : svpTstValidationData.getValidationData()) {
                String tstValidationDataHash = ReportUtil.calculateSHA256(tstValidationDataBytes);
                VOReferenceType tstValidationDataRef = reportContext.getCertificateReference(tstValidationDataHash);
                if (tstValidationDataRef == null) {
                    tstValidationDataRef = reportContext.getCRLReference(tstValidationDataHash);
                }
                if (tstValidationDataRef == null) {
                    tstValidationDataRef = reportContext.getOCSPReference(tstValidationDataHash);
                }
                if (tstValidationDataRef == null) continue;
                List validationObjectReferences = svrTimeStampValidationData.getAttributeObject();
                validationObjectReferences.add(tstValidationDataRef);
            }
            result = this.svrFactory.createSignatureAttributesTypeTimeStampValidationData(svrTimeStampValidationData);
        }
        if (result == null && this.nextTransformer != null) {
            result = this.nextTransformer.transform(attrToTransform, signatureValidationResult, reportContext);
        }
        return result;
    }
}

