/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.sig_val_report.sigattributes;

import de.governikus.csl.sig_val_report.ReportCreationContext;
import de.governikus.csl.sig_val_report.ReportUtil;
import de.governikus.csl.sig_val_report.sigattributes.SVPSigAttributeToSVRTransformer;
import de.governikus.csl.uom.validate.SignatureValidationResult;
import de.governikus.csl.validate.svp.AttributeBaseType;
import de.governikus.csl.validate.svp.TimeAttributeType;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.etsi.uri._19102.v1_2_2.ObjectFactory;
import org.etsi.uri._19102.v1_2_2.SASigningTimeType;
import org.etsi.uri._19102.v1_2_2.SATimestampType;
import org.etsi.uri._19102.v1_2_2.VOReferenceType;

public class TimeAttributeTypeTransformer
implements SVPSigAttributeToSVRTransformer {
    private final ObjectFactory svrFactory;
    private SVPSigAttributeToSVRTransformer nextTransformer;

    public TimeAttributeTypeTransformer(ObjectFactory svrFactory) {
        this.svrFactory = svrFactory;
    }

    @Override
    public SVPSigAttributeToSVRTransformer append(SVPSigAttributeToSVRTransformer next) {
        this.nextTransformer = next;
        return next;
    }

    @Override
    public JAXBElement<?> transform(JAXBElement<? extends AttributeBaseType> attrToTransform, SignatureValidationResult signatureValidationResult, ReportCreationContext reportContext) {
        JAXBElement<?> result = null;
        if (attrToTransform.getDeclaredType() == TimeAttributeType.class) {
            TimeAttributeType timeAttribute = (TimeAttributeType)attrToTransform.getValue();
            Date dateTime = timeAttribute.getTime();
            XMLGregorianCalendar xmlCalendar = ReportUtil.createXMLCalendar(dateTime);
            boolean isSignedAttribute = timeAttribute.isSigned();
            QName qName = attrToTransform.getName();
            String localName = qName.getLocalPart();
            if ("signingTime".equals(localName)) {
                result = this.createSigningTimeObject(xmlCalendar, isSignedAttribute);
            } else {
                VOReferenceType tstValidationObjectRef = reportContext.getTimeStampReference(dateTime.toString());
                result = this.createTimeStampObject(xmlCalendar, isSignedAttribute, localName, tstValidationObjectRef);
            }
        }
        if (result == null && this.nextTransformer != null) {
            result = this.nextTransformer.transform(attrToTransform, signatureValidationResult, reportContext);
        }
        return result;
    }

    private JAXBElement<?> createTimeStampObject(XMLGregorianCalendar xmlCalendar, boolean isSignedAttribute, String localName, VOReferenceType tstValidationObjectRef) {
        JAXBElement result;
        SATimestampType timeStampType = this.svrFactory.createSATimestampType();
        timeStampType.setSigned(Boolean.valueOf(isSignedAttribute));
        timeStampType.setTimeStampValue(xmlCalendar);
        if (tstValidationObjectRef != null) {
            List attributeReferences = timeStampType.getAttributeObject();
            attributeReferences.add(tstValidationObjectRef);
        }
        switch (localName) {
            case "allDataObjectsTimeStamp": {
                result = this.svrFactory.createSignatureAttributesTypeAllDataObjectsTimeStamp(timeStampType);
                break;
            }
            case "archiveTimeStamp": {
                result = this.svrFactory.createSignatureAttributesTypeArchiveTimeStamp(timeStampType);
                break;
            }
            case "individualDataObjectsTimeStamp": {
                result = this.svrFactory.createSignatureAttributesTypeIndividualDataObjectsTimeStamp(timeStampType);
                break;
            }
            case "signatureTimeStamp": {
                result = this.svrFactory.createSignatureAttributesTypeSignatureTimeStamp(timeStampType);
                break;
            }
            case "sigAndRefsTimeStamp": {
                result = this.svrFactory.createSignatureAttributesTypeSigAndRefsTimeStamp(timeStampType);
                break;
            }
            case "refsOnlyTimeStamp": {
                result = this.svrFactory.createSignatureAttributesTypeRefsOnlyTimeStamp(timeStampType);
                break;
            }
            case "docTimeStamp": {
                result = this.svrFactory.createSignatureAttributesTypeDocTimeStamp(timeStampType);
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    private JAXBElement<?> createSigningTimeObject(XMLGregorianCalendar xmlCalendar, boolean isSignedAttribute) {
        SASigningTimeType saSigningTime = this.svrFactory.createSASigningTimeType();
        saSigningTime.setSigned(Boolean.valueOf(isSignedAttribute));
        saSigningTime.setTime(xmlCalendar);
        return this.svrFactory.createSignatureAttributesTypeSigningTime(saSigningTime);
    }
}

