/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.sig_val_report.sigattributes;

import de.governikus.csl.sig_val_report.ReportCreationContext;
import de.governikus.csl.sig_val_report.sigattributes.SVPSigAttributeToSVRTransformer;
import de.governikus.csl.uom.validate.SignatureValidationResult;
import de.governikus.csl.validate.svp.AttributeBaseType;
import de.governikus.csl.validate.svp.SignerLocationType;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.etsi.uri._19102.v1_2_2.ObjectFactory;
import org.etsi.uri._19102.v1_2_2.SASignatureProductionPlaceType;

public class SignerLocationTypeTransformer
implements SVPSigAttributeToSVRTransformer {
    private final ObjectFactory svrFactory;
    private SVPSigAttributeToSVRTransformer nextTransformer;

    public SignerLocationTypeTransformer(ObjectFactory svrFactory) {
        this.svrFactory = svrFactory;
    }

    @Override
    public SVPSigAttributeToSVRTransformer append(SVPSigAttributeToSVRTransformer next) {
        this.nextTransformer = next;
        return next;
    }

    @Override
    public JAXBElement<?> transform(JAXBElement<? extends AttributeBaseType> attrToTransform, SignatureValidationResult signatureValidationResult, ReportCreationContext reportContext) {
        JAXBElement result = null;
        if (attrToTransform.getDeclaredType() == SignerLocationType.class) {
            SignerLocationType svpSignerLocation = (SignerLocationType)attrToTransform.getValue();
            SASignatureProductionPlaceType svrSignerLocation = this.svrFactory.createSASignatureProductionPlaceType();
            svrSignerLocation.setSigned(svpSignerLocation.isSigned());
            List svrAddressStrings = svrSignerLocation.getAddressString();
            if (!svpSignerLocation.getAddress().isEmpty()) {
                List svpAddressStrings = svpSignerLocation.getAddress();
                svpAddressStrings.forEach(e -> svrAddressStrings.add(e));
            }
            if (svpSignerLocation.getLocalityName() != null) {
                svrAddressStrings.add(svpSignerLocation.getLocalityName());
            }
            if (svpSignerLocation.getCountryName() != null) {
                svrAddressStrings.add(svpSignerLocation.getCountryName());
            }
            result = this.svrFactory.createSignatureAttributesTypeSignatureProductionPlace(svrSignerLocation);
        }
        if (result == null && this.nextTransformer != null) {
            result = this.nextTransformer.transform(attrToTransform, signatureValidationResult, reportContext);
        }
        return result;
    }
}

