/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.sig_val_report.sigattributes;

import de.governikus.csl.sig_val_report.ReportCreationContext;
import de.governikus.csl.sig_val_report.ReportUtil;
import de.governikus.csl.sig_val_report.sigattributes.SVPSigAttributeToSVRTransformer;
import de.governikus.csl.uom.validate.SignatureValidationResult;
import de.governikus.csl.validate.svp.AttributeBaseType;
import de.governikus.csl.validate.svp.SigPolicyIdentifierType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBElement;
import org.etsi.uri._19102.v1_2_2.ObjectFactory;
import org.etsi.uri._19102.v1_2_2.SASigPolicyIdentifierType;

public class SigPolicyIdentifierTypeTransformer
implements SVPSigAttributeToSVRTransformer {
    private static final Pattern OID_PATTERN = Pattern.compile("^\\d\\.(?:\\d+\\.){0,100}\\d+$");
    private final ObjectFactory svrFactory;
    private SVPSigAttributeToSVRTransformer nextTransformer;

    public SigPolicyIdentifierTypeTransformer(ObjectFactory svrFactory) {
        this.svrFactory = svrFactory;
    }

    @Override
    public SVPSigAttributeToSVRTransformer append(SVPSigAttributeToSVRTransformer next) {
        this.nextTransformer = next;
        return next;
    }

    @Override
    public JAXBElement<?> transform(JAXBElement<? extends AttributeBaseType> attrToTransform, SignatureValidationResult signatureValidationResult, ReportCreationContext reportContext) {
        JAXBElement result = null;
        if (attrToTransform.getDeclaredType() == SigPolicyIdentifierType.class) {
            SigPolicyIdentifierType svpSigPolicyId = (SigPolicyIdentifierType)attrToTransform.getValue();
            SASigPolicyIdentifierType saSigPolicyId = this.svrFactory.createSASigPolicyIdentifierType();
            saSigPolicyId.setSigned(svpSigPolicyId.isSigned());
            String sigPolicyIdentifier = svpSigPolicyId.getSigPolicyId();
            String svrPolicyIdString = this.isOid(sigPolicyIdentifier) ? ReportUtil.createUrnFromOid(sigPolicyIdentifier) : sigPolicyIdentifier;
            saSigPolicyId.setSigPolicyId(svrPolicyIdString);
            result = this.svrFactory.createSignatureAttributesTypeSigPolicyIdentifier(saSigPolicyId);
        }
        if (result == null && this.nextTransformer != null) {
            result = this.nextTransformer.transform(attrToTransform, signatureValidationResult, reportContext);
        }
        return result;
    }

    private boolean isOid(String sigPolicyIdentifier) {
        Matcher oidPatternMatcher = OID_PATTERN.matcher(sigPolicyIdentifier);
        return oidPatternMatcher.matches();
    }
}

