/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.sig_val_report.sigattributes;

import de.governikus.csl.sig_val_report.ReportCreationContext;
import de.governikus.csl.sig_val_report.ReportUtil;
import de.governikus.csl.sig_val_report.sigattributes.SVPSigAttributeToSVRTransformer;
import de.governikus.csl.uom.validate.SignatureValidationResult;
import de.governikus.csl.validate.svp.RevocationValuesType;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.etsi.uri._19102.v1_2_2.AttributeBaseType;
import org.etsi.uri._19102.v1_2_2.ObjectFactory;
import org.etsi.uri._19102.v1_2_2.VOReferenceType;

public class RevocationValuesTypeTransformer
implements SVPSigAttributeToSVRTransformer {
    private final ObjectFactory svrFactory;
    private SVPSigAttributeToSVRTransformer nextTransformer;

    public RevocationValuesTypeTransformer(ObjectFactory svrFactory) {
        this.svrFactory = svrFactory;
    }

    @Override
    public SVPSigAttributeToSVRTransformer append(SVPSigAttributeToSVRTransformer next) {
        this.nextTransformer = next;
        return next;
    }

    @Override
    public JAXBElement<?> transform(JAXBElement<? extends de.governikus.csl.validate.svp.AttributeBaseType> attrToTransform, SignatureValidationResult signatureValidationResult, ReportCreationContext reportContext) {
        JAXBElement<?> result = null;
        if (attrToTransform.getDeclaredType() == RevocationValuesType.class) {
            RevocationValuesType svpRevocationValuesObject = (RevocationValuesType)attrToTransform.getValue();
            AttributeBaseType svrRevocationValuesAttr = this.svrFactory.createAttributeBaseType();
            svrRevocationValuesAttr.setSigned(svpRevocationValuesObject.isSigned());
            for (byte[] svpRevocationValueBytes : svpRevocationValuesObject.getRevocationValue()) {
                String revocationValueHash = ReportUtil.calculateSHA256(svpRevocationValueBytes);
                VOReferenceType revocationValueRef = reportContext.getOCSPReference(revocationValueHash);
                if (revocationValueRef == null) {
                    revocationValueRef = reportContext.getCRLReference(revocationValueHash);
                }
                if (revocationValueRef != null) {
                    List validationObjectReferences = svrRevocationValuesAttr.getAttributeObject();
                    validationObjectReferences.add(revocationValueRef);
                }
                QName attrQName = attrToTransform.getName();
                String attrNameString = attrQName.getLocalPart();
                result = this.createJAXBElement(svrRevocationValuesAttr, attrNameString);
            }
        }
        if (result == null && this.nextTransformer != null) {
            result = this.nextTransformer.transform(attrToTransform, signatureValidationResult, reportContext);
        }
        return result;
    }

    private JAXBElement<?> createJAXBElement(AttributeBaseType svrRevocationValuesAttr, String attrNameString) {
        JAXBElement result = null;
        if ("revocationValues".equals(attrNameString)) {
            result = this.svrFactory.createSignatureAttributesTypeRevocationValues(svrRevocationValuesAttr);
        } else if ("attributeRevocationValues".equals(attrNameString)) {
            result = this.svrFactory.createSignatureAttributesTypeAttributeRevocationValues(svrRevocationValuesAttr);
        }
        return result;
    }
}

