/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.sig_val_report.sigattributes;

import de.governikus.csl.sig_val_report.ReportCreationContext;
import de.governikus.csl.sig_val_report.ReportUtil;
import de.governikus.csl.sig_val_report.sigattributes.SVPSigAttributeToSVRTransformer;
import de.governikus.csl.uom.validate.SignatureValidationResult;
import de.governikus.csl.validate.svp.AttributeBaseType;
import de.governikus.csl.validate.svp.CRLIDType;
import de.governikus.csl.validate.svp.DigestAlgorithm;
import de.governikus.csl.validate.svp.OCSPIDType;
import de.governikus.csl.validate.svp.RevIDListType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.etsi.uri._19102.v1_2_2.ObjectFactory;
import org.etsi.uri._19102.v1_2_2.SACRLIDType;
import org.etsi.uri._19102.v1_2_2.SAOCSPIDType;
import org.etsi.uri._19102.v1_2_2.SARevIDListType;
import org.w3._2000._09.xmldsig.DigestMethodType;

public class RevIDListTypeTransformer
implements SVPSigAttributeToSVRTransformer {
    private final ObjectFactory svrFactory;
    private SVPSigAttributeToSVRTransformer nextTransformer;

    public RevIDListTypeTransformer(ObjectFactory svrFactory) {
        this.svrFactory = svrFactory;
    }

    @Override
    public SVPSigAttributeToSVRTransformer append(SVPSigAttributeToSVRTransformer next) {
        this.nextTransformer = next;
        return next;
    }

    @Override
    public JAXBElement<?> transform(JAXBElement<? extends AttributeBaseType> attrToTransform, SignatureValidationResult signatureValidationResult, ReportCreationContext reportContext) {
        Object result = null;
        if (attrToTransform.getDeclaredType() == RevIDListType.class) {
            RevIDListType svpRevIDListType = (RevIDListType)attrToTransform.getValue();
            List svpCrlOrOcspRevocationRefs = svpRevIDListType.getCRLIDOrOCSPID();
            ArrayList<Object> saCrlIdsorOCSPIdsTmp = new ArrayList<Object>();
            for (Serializable svpCrlOrOcspRevocationRef : svpCrlOrOcspRevocationRefs) {
                if (svpCrlOrOcspRevocationRef instanceof CRLIDType) {
                    CRLIDType svpCrlId = (CRLIDType)svpCrlOrOcspRevocationRef;
                    SACRLIDType saCRLID = this.transformSvpCRLID(svpCrlId);
                    saCrlIdsorOCSPIdsTmp.add(saCRLID);
                    continue;
                }
                if (!(svpCrlOrOcspRevocationRef instanceof OCSPIDType)) continue;
                OCSPIDType svpOcspId = (OCSPIDType)svpCrlOrOcspRevocationRef;
                SAOCSPIDType saOCSPOID = this.transformSvpOCSPID(svpOcspId);
                saCrlIdsorOCSPIdsTmp.add(saOCSPOID);
            }
            SARevIDListType saRevIDListType = this.svrFactory.createSARevIDListType();
            saRevIDListType.setSigned(svpRevIDListType.isSigned());
            List saCrlIdsOrOCSPIDs = saRevIDListType.getCRLIDOrOCSPID();
            saCrlIdsOrOCSPIDs.addAll(saCrlIdsorOCSPIdsTmp);
            QName qName = attrToTransform.getName();
            result = this.createRevIDListTypeJAXBElem(saRevIDListType, qName);
        }
        if (result == null && this.nextTransformer != null) {
            result = this.nextTransformer.transform(attrToTransform, signatureValidationResult, reportContext);
        }
        return result;
    }

    private SAOCSPIDType transformSvpOCSPID(OCSPIDType svpOcspId) {
        SAOCSPIDType result = this.svrFactory.createSAOCSPIDType();
        XMLGregorianCalendar xmlCalendar = ReportUtil.createXMLCalendar(svpOcspId.getProducedAt());
        result.setProducedAt(xmlCalendar);
        result.setResponderIDByName(svpOcspId.getResponderIDByName());
        result.setResponderIDByKey(svpOcspId.getResponderIDByKey());
        return result;
    }

    private JAXBElement<SARevIDListType> createRevIDListTypeJAXBElem(SARevIDListType saRevIDListType, QName qName) {
        JAXBElement result;
        String localName;
        switch (localName = qName.getLocalPart()) {
            case "completeRevocationRefs": {
                result = this.svrFactory.createSignatureAttributesTypeCompleteRevocationRefs(saRevIDListType);
                break;
            }
            case "attributeRevocationRefs": {
                result = this.svrFactory.createSignatureAttributesTypeAttributeRevocationRefs(saRevIDListType);
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    private SACRLIDType transformSvpCRLID(CRLIDType svpCrlId) {
        DigestAlgorithm digestMethod = svpCrlId.getDigestMethod();
        String digestMethodString = ReportUtil.createUrnFromOid(digestMethod.getOID());
        DigestMethodType digestMethodType = new DigestMethodType();
        digestMethodType.setAlgorithm(digestMethodString);
        SACRLIDType saCRLID = this.svrFactory.createSACRLIDType();
        saCRLID.setDigestValue(svpCrlId.getDigestValue());
        saCRLID.setDigestMethod(digestMethodType);
        return saCRLID;
    }
}

