/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.sig_val_report.sigattributes;

import de.governikus.csl.sig_val_report.ReportCreationContext;
import de.governikus.csl.sig_val_report.sigattributes.SVPSigAttributeToSVRTransformer;
import de.governikus.csl.uom.validate.SignatureValidationResult;
import de.governikus.csl.validate.svp.AttributeBaseType;
import de.governikus.csl.validate.svp.RecomputedDigestValueType;
import de.governikus.csl.validate.svp.RenewedDigestsType;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBElement;
import org.etsi.uri._19102.v1_2_2.ObjectFactory;

public class RenewedDigestsTypeTransformer
implements SVPSigAttributeToSVRTransformer {
    private final ObjectFactory svrFactory;
    private SVPSigAttributeToSVRTransformer nextTransformer;

    public RenewedDigestsTypeTransformer(ObjectFactory svrFactory) {
        this.svrFactory = svrFactory;
    }

    @Override
    public SVPSigAttributeToSVRTransformer append(SVPSigAttributeToSVRTransformer next) {
        this.nextTransformer = next;
        return next;
    }

    @Override
    public JAXBElement<?> transform(JAXBElement<? extends AttributeBaseType> attrToTransform, SignatureValidationResult signatureValidationResult, ReportCreationContext reportContext) {
        JAXBElement result = null;
        if (attrToTransform.getDeclaredType() == RenewedDigestsType.class) {
            RenewedDigestsType renewedDigestsType = (RenewedDigestsType)attrToTransform.getValue();
            List integerList = renewedDigestsType.getRecomputedDigestValue().stream().map(RecomputedDigestValueType::getOrder).collect(Collectors.toList());
            result = this.svrFactory.createSignatureAttributesTypeRenewedDigests(integerList);
        }
        if (result == null && this.nextTransformer != null) {
            result = this.nextTransformer.transform(attrToTransform, signatureValidationResult, reportContext);
        }
        return result;
    }
}

