/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.sig_val_report.sigattributes;

import de.governikus.csl.sig_val_report.ReportCreationContext;
import de.governikus.csl.sig_val_report.sigattributes.SVPSigAttributeToSVRTransformer;
import de.governikus.csl.uom.validate.SignatureValidationResult;
import de.governikus.csl.validate.svp.AttributeBaseType;
import de.governikus.csl.validate.svp.MessageDigestType;
import javax.xml.bind.JAXBElement;
import org.etsi.uri._19102.v1_2_2.ObjectFactory;
import org.etsi.uri._19102.v1_2_2.SAMessageDigestType;

public class MessageDigestTypeTransformer
implements SVPSigAttributeToSVRTransformer {
    private final ObjectFactory svrFactory;
    private SVPSigAttributeToSVRTransformer nextTransformer;

    public MessageDigestTypeTransformer(ObjectFactory svrFactory) {
        this.svrFactory = svrFactory;
    }

    @Override
    public SVPSigAttributeToSVRTransformer append(SVPSigAttributeToSVRTransformer next) {
        this.nextTransformer = next;
        return next;
    }

    @Override
    public JAXBElement<?> transform(JAXBElement<? extends AttributeBaseType> attrToTransform, SignatureValidationResult signatureValidationResult, ReportCreationContext reportContext) {
        JAXBElement result = null;
        if (attrToTransform.getDeclaredType() == MessageDigestType.class) {
            MessageDigestType svpMessageDigest = (MessageDigestType)attrToTransform.getValue();
            SAMessageDigestType saMessageDigest = this.svrFactory.createSAMessageDigestType();
            saMessageDigest.setSigned(svpMessageDigest.isSigned());
            byte[] svpMessageDigestBytes = svpMessageDigest.getDigestValue();
            saMessageDigest.setDigest((byte[])svpMessageDigestBytes.clone());
            result = this.svrFactory.createSignatureAttributesTypeMessageDigest(saMessageDigest);
        }
        if (result == null && this.nextTransformer != null) {
            result = this.nextTransformer.transform(attrToTransform, signatureValidationResult, reportContext);
        }
        return result;
    }
}

