/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.sig_val_report.sigattributes;

import de.governikus.csl.sig_val_report.ReportCreationContext;
import de.governikus.csl.sig_val_report.sigattributes.SVPSigAttributeToSVRTransformer;
import de.governikus.csl.uom.validate.SignatureValidationResult;
import de.governikus.csl.validate.svp.AttributeBaseType;
import de.governikus.csl.validate.svp.IntegerListType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.etsi.uri._19102.v1_2_2.ObjectFactory;

public class IntegerListTypeTransformer
implements SVPSigAttributeToSVRTransformer {
    private final ObjectFactory svrFactory;
    private SVPSigAttributeToSVRTransformer nextTransformer;

    public IntegerListTypeTransformer(ObjectFactory svrFactory) {
        this.svrFactory = svrFactory;
    }

    @Override
    public SVPSigAttributeToSVRTransformer append(SVPSigAttributeToSVRTransformer next) {
        this.nextTransformer = next;
        return next;
    }

    @Override
    public JAXBElement<?> transform(JAXBElement<? extends AttributeBaseType> attrToTransform, SignatureValidationResult signatureValidationResult, ReportCreationContext reportContext) {
        JAXBElement<?> result = null;
        if (attrToTransform.getDeclaredType() == IntegerListType.class) {
            IntegerListType integerList = (IntegerListType)attrToTransform.getValue();
            ArrayList<BigInteger> svrIntegerList = new ArrayList<BigInteger>();
            List svpIntegerList = integerList.getIntegerList();
            svrIntegerList.addAll(svpIntegerList);
            QName svpElemQName = attrToTransform.getName();
            String svpElemLocalName = svpElemQName.getLocalPart();
            result = this.createSVRSAListOfIntegers(svpElemLocalName, svrIntegerList);
        }
        if (result == null && this.nextTransformer != null) {
            result = this.nextTransformer.transform(attrToTransform, signatureValidationResult, reportContext);
        }
        return result;
    }

    private JAXBElement<?> createSVRSAListOfIntegers(String svpElemLocalName, List<BigInteger> svrIntegerList) {
        Object result = "byteRange".equals(svpElemLocalName) ? this.svrFactory.createSignatureAttributesTypeByteRange(svrIntegerList) : ("renewedDigests".equals(svpElemLocalName) ? this.svrFactory.createSignatureAttributesTypeRenewedDigests(svrIntegerList) : null);
        return result;
    }
}

