/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.sig_val_report.sigattributes;

import de.governikus.csl.sig_val_report.ReportCreationContext;
import de.governikus.csl.sig_val_report.ReportUtil;
import de.governikus.csl.sig_val_report.sigattributes.SVPSigAttributeToSVRTransformer;
import de.governikus.csl.uom.validate.SignatureValidationResult;
import de.governikus.csl.validate.svp.AttributeBaseType;
import de.governikus.csl.validate.svp.CounterSignatureType;
import de.governikus.csl.validate.svp.DigestAlgorithm;
import javax.xml.bind.JAXBElement;
import org.etsi.uri._19102.v1_2_2.ObjectFactory;
import org.etsi.uri._19102.v1_2_2.SACounterSignatureType;
import org.etsi.uri._19102.v1_2_2.SignatureReferenceType;

public class CounterSignatureTypeTransformer
implements SVPSigAttributeToSVRTransformer {
    private final ObjectFactory svrFactory;
    private SVPSigAttributeToSVRTransformer nextTransformer;

    public CounterSignatureTypeTransformer(ObjectFactory svrFactory) {
        this.svrFactory = svrFactory;
    }

    @Override
    public SVPSigAttributeToSVRTransformer append(SVPSigAttributeToSVRTransformer next) {
        this.nextTransformer = next;
        return next;
    }

    @Override
    public JAXBElement<?> transform(JAXBElement<? extends AttributeBaseType> attrToTransform, SignatureValidationResult signatureValidationResult, ReportCreationContext reportContext) {
        JAXBElement result = null;
        if (CounterSignatureType.class == attrToTransform.getDeclaredType()) {
            CounterSignatureType svpCounterSignatureType = (CounterSignatureType)attrToTransform.getValue();
            de.governikus.csl.validate.svp.SignatureReferenceType svpSignatureRef = (de.governikus.csl.validate.svp.SignatureReferenceType)svpCounterSignatureType.getCounterSignature().get(0);
            SignatureReferenceType svrSignatureRef = this.svrFactory.createSignatureReferenceType();
            svrSignatureRef.setCanonicalizationMethod(svpSignatureRef.getCanonicalizationMethod());
            String digestMethod = this.createDigestMethodUri(svpSignatureRef.getDigestMethod());
            svrSignatureRef.setDigestMethod(digestMethod);
            svrSignatureRef.setDigestValue((byte[])svpSignatureRef.getDigestValue().clone());
            SACounterSignatureType saCounterSignatureType = this.svrFactory.createSACounterSignatureType();
            saCounterSignatureType.setSigned(svpCounterSignatureType.isSigned());
            saCounterSignatureType.setCounterSignature(svrSignatureRef);
            result = this.svrFactory.createSignatureAttributesTypeCounterSignature(saCounterSignatureType);
        }
        if (result == null && this.nextTransformer != null) {
            result = this.nextTransformer.transform(attrToTransform, signatureValidationResult, reportContext);
        }
        return result;
    }

    private String createDigestMethodUri(DigestAlgorithm digestMethod) {
        String digestMethodUri = null;
        if (digestMethod.getURI() != null) {
            digestMethodUri = digestMethod.getURI();
        } else if (digestMethod.getOID() != null) {
            digestMethodUri = ReportUtil.createUrnFromOid(digestMethod.getOID());
        }
        return digestMethodUri;
    }
}

