/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.sig_val_report.sigattributes;

import de.governikus.csl.sig_val_report.ReportCreationContext;
import de.governikus.csl.sig_val_report.ReportUtil;
import de.governikus.csl.sig_val_report.sigattributes.SVPSigAttributeToSVRTransformer;
import de.governikus.csl.svp.cades.CAdESSignatureValidationResultExt;
import de.governikus.csl.svp.pades.PAdESRevisionValidationResultExt;
import de.governikus.csl.svp.xades.XAdESSignatureValidationResultExt;
import de.governikus.csl.uom.validate.SignatureValidationResult;
import de.governikus.csl.validate.svp.AttributeBaseType;
import de.governikus.csl.validate.svp.CommitmentTypeIndicationType;
import javax.xml.bind.JAXBElement;
import org.etsi.uri._19102.v1_2_2.ObjectFactory;
import org.etsi.uri._19102.v1_2_2.SACommitmentTypeIndicationType;

public class CommitmentTypeIndicationTypeTransformer
implements SVPSigAttributeToSVRTransformer {
    private final ObjectFactory svrFactory;
    private SVPSigAttributeToSVRTransformer nextTransformer;

    public CommitmentTypeIndicationTypeTransformer(ObjectFactory svrFactory) {
        this.svrFactory = svrFactory;
    }

    @Override
    public SVPSigAttributeToSVRTransformer append(SVPSigAttributeToSVRTransformer next) {
        this.nextTransformer = next;
        return next;
    }

    @Override
    public JAXBElement<?> transform(JAXBElement<? extends AttributeBaseType> attrToTransform, SignatureValidationResult signatureValidationResult, ReportCreationContext reportContext) {
        Object result = null;
        if (attrToTransform.getDeclaredType() == CommitmentTypeIndicationType.class) {
            CommitmentTypeIndicationType commitmentTypeIndication = (CommitmentTypeIndicationType)attrToTransform.getValue();
            if (signatureValidationResult instanceof CAdESSignatureValidationResultExt || signatureValidationResult instanceof PAdESRevisionValidationResultExt) {
                result = this.createSACommitmentTypeWithOid(commitmentTypeIndication);
            } else if (signatureValidationResult instanceof XAdESSignatureValidationResultExt) {
                result = this.createSACommitmentTypeWithUri(commitmentTypeIndication);
            }
        }
        if (result == null && this.nextTransformer != null) {
            result = this.nextTransformer.transform(attrToTransform, signatureValidationResult, reportContext);
        }
        return result;
    }

    private JAXBElement<SACommitmentTypeIndicationType> createSACommitmentTypeWithUri(CommitmentTypeIndicationType commitmentTypeIndication) {
        String commitmentUri = "";
        switch (commitmentTypeIndication.getCommitment()) {
            case PROOF_OF_APPROVAL: {
                commitmentUri = commitmentUri + "http://uri.etsi.org/01903/v1.2.2#ProofOfApproval";
                break;
            }
            case PROOF_OF_CREATION: {
                commitmentUri = commitmentUri + "http://uri.etsi.org/01903/v1.2.2#ProofOfCreation";
                break;
            }
            case PROOF_OF_DELIVERY: {
                commitmentUri = commitmentUri + "http://uri.etsi.org/01903/v1.2.2#ProofOfDelivery";
                break;
            }
            case PROOF_OF_ORIGIN: {
                commitmentUri = commitmentUri + "http://uri.etsi.org/01903/v1.2.2#ProofOfOrigin";
                break;
            }
            case PROOF_OF_RECEIPT: {
                commitmentUri = commitmentUri + "http://uri.etsi.org/01903/v1.2.2#ProofOfReceipt";
                break;
            }
            case PROOF_OF_SENDER: {
                commitmentUri = commitmentUri + "http://uri.etsi.org/01903/v1.2.2#ProofOfSender";
            }
        }
        return this.createCommitmentTypeIndicationElem(commitmentUri);
    }

    private JAXBElement<SACommitmentTypeIndicationType> createSACommitmentTypeWithOid(CommitmentTypeIndicationType commitmentTypeIndication) {
        String commitmentUrn = null;
        switch (commitmentTypeIndication.getCommitment()) {
            case PROOF_OF_APPROVAL: {
                commitmentUrn = ReportUtil.createUrnFromOid("1.2.840.113549.1.9.16.6.5");
                break;
            }
            case PROOF_OF_CREATION: {
                commitmentUrn = ReportUtil.createUrnFromOid("1.2.840.113549.1.9.16.6.6");
                break;
            }
            case PROOF_OF_DELIVERY: {
                commitmentUrn = ReportUtil.createUrnFromOid("1.2.840.113549.1.9.16.6.3");
                break;
            }
            case PROOF_OF_ORIGIN: {
                commitmentUrn = ReportUtil.createUrnFromOid("1.2.840.113549.1.9.16.6.1");
                break;
            }
            case PROOF_OF_RECEIPT: {
                commitmentUrn = ReportUtil.createUrnFromOid("1.2.840.113549.1.9.16.6.2");
                break;
            }
            case PROOF_OF_SENDER: {
                commitmentUrn = ReportUtil.createUrnFromOid("1.2.840.113549.1.9.16.6.4");
            }
        }
        return this.createCommitmentTypeIndicationElem(commitmentUrn);
    }

    private JAXBElement<SACommitmentTypeIndicationType> createCommitmentTypeIndicationElem(String commitmentTypeIndication) {
        SACommitmentTypeIndicationType saCommitmentTypeIndication = this.svrFactory.createSACommitmentTypeIndicationType();
        saCommitmentTypeIndication.setSigned(Boolean.TRUE);
        saCommitmentTypeIndication.setCommitmentTypeIdentifier(commitmentTypeIndication);
        return this.svrFactory.createSignatureAttributesTypeCommitmentTypeIndication(saCommitmentTypeIndication);
    }
}

