/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.sig_val_report.sigattributes;

import de.governikus.csl.sig_val_report.ReportCreationContext;
import de.governikus.csl.sig_val_report.ReportUtil;
import de.governikus.csl.sig_val_report.sigattributes.SVPSigAttributeToSVRTransformer;
import de.governikus.csl.uom.validate.SignatureValidationResult;
import de.governikus.csl.validate.svp.CertificateValuesType;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.etsi.uri._19102.v1_2_2.AttributeBaseType;
import org.etsi.uri._19102.v1_2_2.ObjectFactory;
import org.etsi.uri._19102.v1_2_2.VOReferenceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateValuesTypeTransformer
implements SVPSigAttributeToSVRTransformer {
    private static final Logger logger = LoggerFactory.getLogger(CertificateValuesTypeTransformer.class);
    private final ObjectFactory svrFactory;
    private SVPSigAttributeToSVRTransformer nextTransformer;

    public CertificateValuesTypeTransformer(ObjectFactory svrFactory) {
        this.svrFactory = svrFactory;
    }

    @Override
    public SVPSigAttributeToSVRTransformer append(SVPSigAttributeToSVRTransformer next) {
        this.nextTransformer = next;
        return next;
    }

    @Override
    public JAXBElement<?> transform(JAXBElement<? extends de.governikus.csl.validate.svp.AttributeBaseType> attrToTransform, SignatureValidationResult signatureValidationResult, ReportCreationContext reportContext) {
        JAXBElement<?> result = null;
        if (attrToTransform.getDeclaredType() == CertificateValuesType.class) {
            CertificateValuesType svpCertValuesObject = (CertificateValuesType)attrToTransform.getValue();
            AttributeBaseType certValuesAttr = this.svrFactory.createAttributeBaseType();
            certValuesAttr.setSigned(svpCertValuesObject.isSigned());
            for (byte[] certBytes : svpCertValuesObject.getCertificateValue()) {
                String certHash = ReportUtil.calculateSHA256(certBytes);
                VOReferenceType certificateReference = reportContext.getCertificateReference(certHash);
                if (certificateReference != null) {
                    List validationObjectReferences = certValuesAttr.getAttributeObject();
                    validationObjectReferences.add(certificateReference);
                    continue;
                }
                logger.debug("Found certificate from CertificateValues or AttrAuthoritiesCertValues extension that is not represented by a SignatureValidationObject. No reference will be created. [certHash={}]");
            }
            QName attrQName = attrToTransform.getName();
            String attrNameString = attrQName.getLocalPart();
            result = this.createJAXBElement(certValuesAttr, attrNameString);
        }
        if (result == null && this.nextTransformer != null) {
            result = this.nextTransformer.transform(attrToTransform, signatureValidationResult, reportContext);
        }
        return result;
    }

    private JAXBElement<?> createJAXBElement(AttributeBaseType certValuesAttr, String attrName) {
        JAXBElement result = null;
        if ("certificateValues".equals(attrName)) {
            result = this.svrFactory.createSignatureAttributesTypeCertificateValues(certValuesAttr);
        } else if ("attrAuthoritiesCertValues".equals(attrName)) {
            result = this.svrFactory.createSignatureAttributesTypeAttrAuthoritiesCertValues(certValuesAttr);
        }
        return result;
    }
}

