/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.sig_val_report.sigattributes;

import de.governikus.csl.sig_val_report.ReportCreationContext;
import de.governikus.csl.sig_val_report.ReportUtil;
import de.governikus.csl.sig_val_report.sigattributes.SVPSigAttributeToSVRTransformer;
import de.governikus.csl.uom.validate.SignatureValidationResult;
import de.governikus.csl.validate.svp.AttributeBaseType;
import de.governikus.csl.validate.svp.CertIDListType;
import de.governikus.csl.validate.svp.CertIDType;
import de.governikus.csl.validate.svp.DigestAlgorithm;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.etsi.uri._19102.v1_2_2.ObjectFactory;
import org.etsi.uri._19102.v1_2_2.SACertIDListType;
import org.etsi.uri._19102.v1_2_2.SACertIDType;
import org.w3._2000._09.xmldsig.DigestMethodType;

public class CertIDListTypeTransformer
implements SVPSigAttributeToSVRTransformer {
    private final ObjectFactory svrFactory;
    private SVPSigAttributeToSVRTransformer nextTransformer;

    public CertIDListTypeTransformer(ObjectFactory svrFactory) {
        this.svrFactory = svrFactory;
    }

    @Override
    public SVPSigAttributeToSVRTransformer append(SVPSigAttributeToSVRTransformer next) {
        this.nextTransformer = next;
        return next;
    }

    @Override
    public JAXBElement<?> transform(JAXBElement<? extends AttributeBaseType> attrToTransform, SignatureValidationResult signatureValidationResult, ReportCreationContext reportContext) {
        JAXBElement<?> result = null;
        if (attrToTransform.getDeclaredType() == CertIDListType.class) {
            SACertIDListType certIDListType = this.svrFactory.createSACertIDListType();
            List svrCertIDs = certIDListType.getCertID();
            CertIDListType svpCertIDListType = (CertIDListType)attrToTransform.getValue();
            List certIDs = svpCertIDListType.getCertID();
            certIDListType.setSigned(svpCertIDListType.isSigned());
            for (CertIDType certID : certIDs) {
                SACertIDType svrCertID = this.svrFactory.createSACertIDType();
                svrCertID.setDigestValue(certID.getDigestValue());
                svrCertID.setX509IssuerSerial(certID.getX509IssuerSerial());
                DigestAlgorithm digestAlgorithm = certID.getDigestMethod();
                String algorithmId = "SHA1".equals(digestAlgorithm.getName()) ? digestAlgorithm.getURI() : ReportUtil.createUrnFromOid(digestAlgorithm.getOID());
                DigestMethodType digestMethod = new DigestMethodType();
                digestMethod.setAlgorithm(algorithmId);
                svrCertID.setDigestMethod(digestMethod);
                svrCertIDs.add(svrCertID);
            }
            result = this.createJAXBType(certIDListType, attrToTransform);
        }
        if (result == null && this.nextTransformer != null) {
            result = this.nextTransformer.transform(attrToTransform, signatureValidationResult, reportContext);
        }
        return result;
    }

    private JAXBElement<?> createJAXBType(SACertIDListType certIDListType, JAXBElement<? extends AttributeBaseType> attrToTransform) {
        JAXBElement result;
        String localName;
        QName attributeName = attrToTransform.getName();
        switch (localName = attributeName.getLocalPart()) {
            case "signingCertificate": {
                result = this.svrFactory.createSignatureAttributesTypeSigningCertificate(certIDListType);
                break;
            }
            case "completeCertificateRefs": {
                result = this.svrFactory.createSignatureAttributesTypeCompleteCertificateRefs(certIDListType);
                break;
            }
            case "attributeCertificateRefs": {
                result = this.svrFactory.createSignatureAttributesTypeAttributeCertificateRefs(certIDListType);
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }
}

