/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.sig_val_report;

import de.governikus.csl.sig_val_report.ObjectValidationResultProcessor;
import de.governikus.csl.sig_val_report.SigValReportFactory;
import de.governikus.csl.svp.ObjectValidationResultExt;
import de.governikus.csl.svp.ObjectValidationResultVisitor;
import de.governikus.csl.uom.validate.ObjectValidationResult;
import de.governikus.csl.uom.validate.ValidateResponse;
import java.util.Collections;
import java.util.List;
import org.etsi.uri._119612._02231.v2_.DigitalIdentityType;
import org.etsi.uri._119612._02231.v2_.TSPInformationType;
import org.etsi.uri._19102.v1_2_2.ObjectFactory;
import org.etsi.uri._19102.v1_2_2.SignatureValidatorType;
import org.etsi.uri._19102.v1_2_2.ValidationReportType;

public class ValidationReportCreator {
    private ObjectFactory objectFactory = new ObjectFactory();
    private List<ValidateResponse> responses;
    private ValidationReportType validationReport;
    private DigitalIdentityType validatorDigitalIdentity;
    private TSPInformationType validatorInformation;
    private SigValReportFactory factory;

    public ValidationReportCreator(ValidateResponse response) {
        this.responses = Collections.singletonList(response);
        this.factory = new SigValReportFactory();
    }

    public ValidationReportCreator(ValidateResponse response, DigitalIdentityType validatorDigitalIdentity, TSPInformationType validatorInformation) {
        this(response);
        this.validatorDigitalIdentity = validatorDigitalIdentity;
        this.validatorInformation = validatorInformation;
    }

    ValidationReportCreator(ValidateResponse response, DigitalIdentityType validatorDigitalIdentity, TSPInformationType validatorInformation, SigValReportFactory factory) {
        this(response);
        this.validatorDigitalIdentity = validatorDigitalIdentity;
        this.validatorInformation = validatorInformation;
        this.factory = factory;
    }

    public ValidationReportType createReport() {
        this.validationReport = this.objectFactory.createValidationReportType();
        for (ValidateResponse resp : this.responses) {
            this.process(resp);
        }
        this.validationReport.setSignatureValidator(this.createSignatureValidator());
        return this.validationReport;
    }

    private SignatureValidatorType createSignatureValidator() {
        if (this.validatorDigitalIdentity == null) {
            return null;
        }
        SignatureValidatorType result = this.objectFactory.createSignatureValidatorType();
        result.getDigitalId().add(this.validatorDigitalIdentity);
        if (this.validatorInformation != null) {
            result.setTSPInformation(this.validatorInformation);
        }
        return result;
    }

    private void process(ValidateResponse resp) {
        ObjectValidationResult documentValidationResult = resp.getDocumentValidationResult();
        ObjectValidationResultProcessor appender = this.factory.createObjectValidationResultProcessor(this.validationReport, resp);
        if (documentValidationResult instanceof ObjectValidationResultExt) {
            ((ObjectValidationResultExt)documentValidationResult).process((ObjectValidationResultVisitor)appender);
        } else {
            appender.visit(documentValidationResult);
        }
    }
}

