/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.sig_val_report;

import de.governikus.csl.sig_val_report.SVRContextHolder;
import de.governikus.csl.sig_val_report.SVRSchemaValidator;
import de.governikus.csl.sig_val_report.SigValReportFactory;
import de.governikus.csl.sig_val_report.ValidationReportCreator;
import de.governikus.csl.uom.output.LayoutException;
import de.governikus.csl.uom.output.OutputPlugin;
import de.governikus.csl.uom.output.SchemaConformityReport;
import de.governikus.csl.uom.validate.ResultInterpreter;
import de.governikus.csl.uom.validate.ValidateResponse;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.xml.bind.JAXBException;
import org.etsi.uri._119612._02231.v2_.DigitalIdentityType;
import org.etsi.uri._19102.v1_2_2.ValidationReportType;
import org.xml.sax.SAXException;

public class SignatureValidationReportOutput
implements OutputPlugin {
    public static final String SETTING_MARSHALLER_INDENTATION = "marshaller.indentation";
    public static final String SETTING_CREATE_VALIDATOR_ID = "validatorid.creation";
    private Locale locale;
    private SigValReportFactory factory = new SigValReportFactory();
    private Map<String, Object> additionalSettings = new HashMap<String, Object>();

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    SigValReportFactory getFactory() {
        return this.factory;
    }

    void setFactory(SigValReportFactory factory) {
        this.factory = factory;
    }

    public String getMimeType() {
        return "text/xml";
    }

    public String getName() {
        return "ETSI Validation Report";
    }

    public void setAdditionalSettings(Map<String, Object> settings) {
        this.additionalSettings = settings;
    }

    public SchemaConformityReport layout(ValidateResponse response, OutputStream out) throws LayoutException {
        try {
            ValidationReportType report = Optional.ofNullable(this.createValidatorId(response)).orElseGet(() -> this.factory.createValidationReportCreator(response)).createReport();
            SchemaConformityReport result = this.createSchemaConformitReport(report);
            boolean indent = this.additionalSettings.getOrDefault(SETTING_MARSHALLER_INDENTATION, Boolean.FALSE).equals(Boolean.TRUE);
            SVRContextHolder.getInstance().marshal(SVRContextHolder.getInstance().getObjectFactory().createValidationReport(report), out, indent);
            return result;
        }
        catch (IOException e) {
            throw new LayoutException((Throwable)e);
        }
    }

    private SchemaConformityReport createSchemaConformitReport(ValidationReportType report) {
        if (this.isSchemaValidationEnabled()) {
            return this.validateSchemaConformity(report);
        }
        return new SchemaConformityReport(MajorTotalResult.NOT_VALIDATED);
    }

    private ValidationReportCreator createValidatorId(ValidateResponse response) {
        Object potentialCert = this.additionalSettings.get(SETTING_CREATE_VALIDATOR_ID);
        if (potentialCert instanceof X509Certificate) {
            X509Certificate certificate = (X509Certificate)potentialCert;
            DigitalIdentityType validatorId = this.createValidator(certificate);
            return new ValidationReportCreator(response, validatorId, null);
        }
        return null;
    }

    private DigitalIdentityType createValidator(X509Certificate certificate) {
        DigitalIdentityType validatorId = new DigitalIdentityType();
        validatorId.setX509SubjectName(certificate.getSubjectX500Principal().getName());
        return validatorId;
    }

    public void setResultInterpreter(List<ResultInterpreter> interpreters) {
    }

    private SchemaConformityReport validateSchemaConformity(ValidationReportType report) {
        SVRSchemaValidator validator = null;
        try {
            validator = SVRSchemaValidator.createInstance();
        }
        catch (SAXException e) {
            return new SchemaConformityReport(MajorTotalResult.INDETERMINATE, "Can't create SVR schema validator");
        }
        try {
            validator.validateReport(report);
        }
        catch (IOException | JAXBException | SAXException e) {
            String msg = e.getMessage();
            if (msg == null && e.getCause() != null) {
                msg = e.getCause().getMessage();
            }
            return new SchemaConformityReport(MajorTotalResult.TOTAL_FAILED, msg);
        }
        return new SchemaConformityReport(MajorTotalResult.TOTAL_PASSED);
    }

    public static ValidationReportType convert(ValidateResponse response) {
        return new ValidationReportCreator(response).createReport();
    }
}

