/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.sig_val_report;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.bos_bremen.algorithm_identifier.SignatureAlgorithm;
import de.governikus.csl.sig_val_report.BaseSignatureValidationReportCreator;
import de.governikus.csl.sig_val_report.ReportCreationContext;
import de.governikus.csl.sig_val_report.ReportUtil;
import de.governikus.csl.svp.AdESSignatureValidationResult;
import de.governikus.csl.uom.validate.SignatureValidationResult;
import de.governikus.csl.uom.validate.ValidatePolicy;
import de.governikus.csl.utils.SignatureAttributesUtils;
import de.governikus.csl.validate.svp.JAdESSignatureValidationResult;
import de.governikus.csl.validate.svp.MessageDigestType;
import de.governikus.csl.validate.svp.SignatureAttributesType;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import org.etsi.uri._01903.v1_3.DigestAlgAndValueType;
import org.etsi.uri._19102.v1_2_2.SignatureValidationReportType;
import org.etsi.uri._19102.v1_2_2.SignersDocumentType;
import org.etsi.uri._19102.v1_2_2.ValidationObjectType;
import org.etsi.uri._19102.v1_2_2.ValidationReportDataType;
import org.w3._2000._09.xmldsig.DigestMethodType;
import org.w3._2000._09.xmldsig.ObjectFactory;

public class SignatureValidationReportCreator
extends BaseSignatureValidationReportCreator<SignatureValidationResult> {
    private static final String JADES_MESSAGE_DIGEST_ALGO = "http://www.w3.org/2007/05/xmldsig-more#sha3-512";
    private final boolean isMainReport;
    private final org.etsi.uri._01903.v1_3.ObjectFactory etsi_01903_v13_ObjectFactory = new org.etsi.uri._01903.v1_3.ObjectFactory();
    private final ObjectFactory xmlDsigObjectFactory = new ObjectFactory();

    public SignatureValidationReportCreator(SignatureValidationResult signatureValidationResult, Date validationDate, Consumer<ValidationObjectType> validationObjectConsumer, ValidatePolicy policy, boolean isMainReport, ReportCreationContext reportContext) {
        super(signatureValidationResult, validationDate, validationObjectConsumer, policy, reportContext);
        this.isMainReport = isMainReport;
    }

    public SignatureValidationReportType createReport() {
        SignatureValidationReportType result = etsiSvrObjectFactory.createSignatureValidationReportType();
        result.setSignatureIdentifier(this.createSignatureIdentifier());
        result.setSignatureValidationStatus(this.createValidationStatus(this.isMainReport));
        result.setValidationConstraintsEvaluationReport(this.createValidationConstraintsEvaluationReport());
        result.setValidationTimeInfo(this.createValidationTimeInfo());
        result.setSignersDocument(this.createSignersDocument());
        result.setSignatureAttributes(this.createSignatureAttributes());
        result.setSignerInformation(this.createSignerInformation());
        result.setSignatureQuality(this.createSignatureQuality());
        result.setSignatureValidationProcess(this.createSignatureValidationProcess());
        ReportUtil.extendWithValidationObjectId(result);
        return result;
    }

    @Override
    protected ValidationReportDataType createValidationReportData() {
        ValidationReportDataType result = etsiSvrObjectFactory.createValidationReportDataType();
        result.setCertificateChain(this.createCertificateChain());
        result.setTrustAnchor(this.createTrustAnchor());
        result.setCryptoInformation(this.createCryptoInformation());
        return result;
    }

    private SignersDocumentType createSignersDocument() {
        if (!(this.signatureValidationResult instanceof AdESSignatureValidationResult)) {
            return null;
        }
        String digestAlogrithmURI = null;
        boolean isJAdESSignatureResult = this.signatureValidationResult instanceof JAdESSignatureValidationResult;
        byte[] digestValue = null;
        if (isJAdESSignatureResult) {
            digestValue = ((JAdESSignatureValidationResult)this.signatureValidationResult).getMessageDigestValue();
            digestAlogrithmURI = JADES_MESSAGE_DIGEST_ALGO;
        } else {
            SignatureAlgorithm signatureAlgorithm = this.signatureValidationResult.getSignatureAlgorithm();
            if (signatureAlgorithm == null) {
                return null;
            }
            DigestAlgorithm digestAlgorithm = signatureAlgorithm.getDigestAlgorithm();
            if (digestAlgorithm == null) {
                return null;
            }
            digestAlogrithmURI = digestAlgorithm.getURI();
            MessageDigestType messageDigest = this.getMessageDigestFromSignatureAttributes((AdESSignatureValidationResult)this.signatureValidationResult);
            if (messageDigest == null) {
                return null;
            }
            digestValue = messageDigest.getDigestValue();
        }
        return this.createSignersDocumentType(digestAlogrithmURI, digestValue);
    }

    private MessageDigestType getMessageDigestFromSignatureAttributes(AdESSignatureValidationResult adesSignatureValidationResult) {
        SignatureAttributesType signatureAttributes = adesSignatureValidationResult.getSignatureAttributes();
        if (signatureAttributes == null) {
            return null;
        }
        return (MessageDigestType)SignatureAttributesUtils.findByNameAndType((String)"messageDigest", MessageDigestType.class, (List)signatureAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat());
    }

    private SignersDocumentType createSignersDocumentType(String digestAlgorithmUri, byte[] digestValue) {
        DigestAlgAndValueType digestAlgAndValueType = this.etsi_01903_v13_ObjectFactory.createDigestAlgAndValueType();
        DigestMethodType digestMethodType = this.xmlDsigObjectFactory.createDigestMethodType();
        digestMethodType.setAlgorithm(digestAlgorithmUri);
        digestAlgAndValueType.setDigestMethod(digestMethodType);
        digestAlgAndValueType.setDigestValue(digestValue);
        SignersDocumentType signersDocumentType = etsiSvrObjectFactory.createSignersDocumentType();
        signersDocumentType.setDigestAlgAndValue(digestAlgAndValueType);
        return signersDocumentType;
    }
}

