/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.sig_val_report;

import de.governikus.csl.svp.AttributeCertificateValidationResultExt;
import de.governikus.csl.svp.PublicKeyCertificateValidationResultExt;
import de.governikus.csl.svp.RevocationValueValidationResultExt;
import de.governikus.csl.svp.SignatureValidationResultVisitor;
import de.governikus.csl.svp.TimestampValidationResultExt;
import de.governikus.csl.svp.cades.CAdESSignatureValidationResultExt;
import de.governikus.csl.svp.osci.OSCISignatureValidationResultExt;
import de.governikus.csl.svp.pades.PAdESRevisionValidationResultExt;
import de.governikus.csl.svp.xades.XAdESSignatureValidationResultExt;
import de.governikus.csl.uom.validate.CertificateQualification;
import de.governikus.csl.uom.validate.CertificateQualificationInformation;
import de.governikus.csl.uom.validate.PublicKeyCertificateValidationResult;
import de.governikus.csl.uom.validate.SignatureValidationResult;
import de.governikus.csl.uom.validate.TimestampQuality;
import de.governikus.csl.uom.validate.commons.EUQualifiedCertificateType;
import java.util.List;
import org.etsi.uri._19102.v1_2_2.SignatureQualityType;

public class SignatureQualityCreator
implements SignatureValidationResultVisitor<SignatureQualityType> {
    public SignatureQualityType visit(SignatureValidationResult signatureValidationResult) {
        PublicKeyCertificateValidationResult signingCertificateValidationResult = signatureValidationResult.getSigningCertificateValidationResult();
        return this.visit(signingCertificateValidationResult);
    }

    public SignatureQualityType visit(CAdESSignatureValidationResultExt signatureValidationResult) {
        return this.visit((SignatureValidationResult)signatureValidationResult);
    }

    public SignatureQualityType visit(OSCISignatureValidationResultExt osciSignatureValidationResult) {
        return this.visit((SignatureValidationResult)osciSignatureValidationResult);
    }

    public SignatureQualityType visit(PAdESRevisionValidationResultExt pAdESRevisionValidationResult) {
        return this.visit((SignatureValidationResult)pAdESRevisionValidationResult);
    }

    public SignatureQualityType visit(XAdESSignatureValidationResultExt xAdESSignatureValidationResult) {
        return this.visit((SignatureValidationResult)xAdESSignatureValidationResult);
    }

    public SignatureQualityType visit(TimestampValidationResultExt timestampValidationResult) {
        TimestampQuality tstQuality = timestampValidationResult.getTimestampQuality();
        String qualityString = "https://www.governikus.de/val-uri/timestamp-level-types";
        qualityString = tstQuality == null ? qualityString + "/" + TimestampQuality.DTST.name() : qualityString + "/" + tstQuality.name();
        SignatureQualityType result = new SignatureQualityType();
        result.getSignatureQualityInformation().add(qualityString);
        return result;
    }

    public SignatureQualityType visit(PublicKeyCertificateValidationResultExt publicKeyCertificateValidationResult) {
        return this.visit((PublicKeyCertificateValidationResult)publicKeyCertificateValidationResult);
    }

    private SignatureQualityType visit(PublicKeyCertificateValidationResult publicKeyCertificateValidationResult) {
        SignatureQualityType result = new SignatureQualityType();
        List signatureQualityInformationResultList = result.getSignatureQualityInformation();
        this.addSignatureQualityInformation(publicKeyCertificateValidationResult, signatureQualityInformationResultList);
        if (signatureQualityInformationResultList.isEmpty()) {
            signatureQualityInformationResultList.add("https://www.governikus.de/val-uri/signature-level-types/unknown");
        }
        return result;
    }

    private void addSignatureQualityInformation(PublicKeyCertificateValidationResult publicKeyCertificateValidationResult, List<String> signatureQualityInformationResultList) {
        this.addSignatureQualityInformationNew(publicKeyCertificateValidationResult, signatureQualityInformationResultList);
        this.addSignatureQualityInformationOld(publicKeyCertificateValidationResult, signatureQualityInformationResultList);
    }

    private void addSignatureQualityInformationOld(PublicKeyCertificateValidationResult publicKeyCertificateValidationResult, List<String> signatureQualityInformationResultList) {
        CertificateQualification certificateQualification = null;
        if (publicKeyCertificateValidationResult != null && publicKeyCertificateValidationResult.getQualityInformation() != null) {
            CertificateQualificationInformation qualityInformation = publicKeyCertificateValidationResult.getQualityInformation();
            certificateQualification = qualityInformation.getCertificateQualification();
            EUQualifiedCertificateType type = qualityInformation.getCertificateType();
            String postfix = "";
            if (type != null) {
                switch (type) {
                    case CERTIFICATE_FOR_ELECTRONIC_SIGNATURES: {
                        break;
                    }
                    case CERTIFICATE_FOR_ELECTRONIC_SEALS: {
                        postfix = "_SEAL";
                        break;
                    }
                    case CERTIFICATE_FOR_WEBSITE_AUTHENTICATION: {
                        postfix = "_WSA";
                        break;
                    }
                }
                String qualityString = "https://www.governikus.de/val-uri/signature-level-types/" + certificateQualification.name() + postfix;
                signatureQualityInformationResultList.add(qualityString);
            }
        }
    }

    private void addSignatureQualityInformationNew(PublicKeyCertificateValidationResult publicKeyCertificateValidationResult, List<String> signatureQualityInformationResultList) {
        if (publicKeyCertificateValidationResult != null && publicKeyCertificateValidationResult.getQualityResult() != null) {
            signatureQualityInformationResultList.addAll(publicKeyCertificateValidationResult.getQualityResult().getSvrQualityURLs());
        }
    }

    public SignatureQualityType visit(RevocationValueValidationResultExt revocationValueValidationResult) {
        return this.visit((SignatureValidationResult)revocationValueValidationResult);
    }

    public SignatureQualityType visit(AttributeCertificateValidationResultExt attributeCertificateValidationResult) {
        return this.visit((SignatureValidationResult)attributeCertificateValidationResult);
    }
}

