/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.sig_val_report;

import de.governikus.csl.sig_val_report.ArchiveTimestampReportCreator;
import de.governikus.csl.sig_val_report.ReportCreationContext;
import de.governikus.csl.sig_val_report.ReportUtil;
import de.governikus.csl.sig_val_report.SigValReportFactory;
import de.governikus.csl.sig_val_report.TimestampReportCreator;
import de.governikus.csl.sig_val_report.sigattributes.CertIDListTypeTransformer;
import de.governikus.csl.sig_val_report.sigattributes.CertificateValuesTypeTransformer;
import de.governikus.csl.sig_val_report.sigattributes.CommitmentTypeIndicationTypeTransformer;
import de.governikus.csl.sig_val_report.sigattributes.ContactInfoTypeTransformer;
import de.governikus.csl.sig_val_report.sigattributes.CounterSignatureTypeTransformer;
import de.governikus.csl.sig_val_report.sigattributes.DataObjectFormatTypeTransformer;
import de.governikus.csl.sig_val_report.sigattributes.FilterTypeTransformer;
import de.governikus.csl.sig_val_report.sigattributes.IntegerListTypeTransformer;
import de.governikus.csl.sig_val_report.sigattributes.MessageDigestTypeTransformer;
import de.governikus.csl.sig_val_report.sigattributes.NameTypeTransformer;
import de.governikus.csl.sig_val_report.sigattributes.RenewedDigestsTypeTransformer;
import de.governikus.csl.sig_val_report.sigattributes.RevIDListTypeTransformer;
import de.governikus.csl.sig_val_report.sigattributes.RevocationValuesTypeTransformer;
import de.governikus.csl.sig_val_report.sigattributes.SigPolicyIdentifierTypeTransformer;
import de.governikus.csl.sig_val_report.sigattributes.SignReasonTypeTransformer;
import de.governikus.csl.sig_val_report.sigattributes.SignerLocationTypeTransformer;
import de.governikus.csl.sig_val_report.sigattributes.SignerRoleTypeTransformer;
import de.governikus.csl.sig_val_report.sigattributes.SubFilterTypeTransformer;
import de.governikus.csl.sig_val_report.sigattributes.TimeAttributeTypeTransformer;
import de.governikus.csl.sig_val_report.sigattributes.TimeStampValidationDataTypeTransformer;
import de.governikus.csl.svp.AdESSignatureValidationResult;
import de.governikus.csl.svp.AttributeCertificateValidationResultExt;
import de.governikus.csl.svp.PublicKeyCertificateValidationResultExt;
import de.governikus.csl.svp.RevocationValueValidationResultExt;
import de.governikus.csl.svp.SignatureValidationResultVisitor;
import de.governikus.csl.svp.TimestampValidationResultExt;
import de.governikus.csl.svp.cades.CAdESSignatureValidationResultExt;
import de.governikus.csl.svp.osci.OSCISignatureValidationResultExt;
import de.governikus.csl.svp.pades.PAdESRevisionValidationResultExt;
import de.governikus.csl.svp.xades.XAdESSignatureValidationResultExt;
import de.governikus.csl.uom.validate.SignatureValidationResult;
import de.governikus.csl.uom.validate.TimestampValidationResult;
import de.governikus.csl.uom.validate.ValidatePolicy;
import de.governikus.csl.validate.svp.ArchiveTimestampValidationResult;
import de.governikus.csl.validate.svp.AttributeBaseType;
import de.governikus.csl.validate.svp.SignatureAttributesType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import javax.xml.bind.JAXBElement;
import org.etsi.uri._19102.v1_2_2.ObjectFactory;
import org.etsi.uri._19102.v1_2_2.SATimestampType;
import org.etsi.uri._19102.v1_2_2.VOReferenceType;
import org.etsi.uri._19102.v1_2_2.ValidationObjectType;

public class SignatureAttributesCreator
implements SignatureValidationResultVisitor<org.etsi.uri._19102.v1_2_2.SignatureAttributesType> {
    private static final ObjectFactory svrFactory = new ObjectFactory();
    private List<JAXBElement<?>> attributeList;
    private SigValReportFactory factory;
    private Date validationDate;
    private ReportCreationContext reportContext;
    private Consumer<ValidationObjectType> validationObjectConsumer;
    private ValidatePolicy policy;

    public SignatureAttributesCreator(Date validationDate, Consumer<ValidationObjectType> validationObjectConsumer, ValidatePolicy policy, ReportCreationContext reportContext) {
        this.factory = new SigValReportFactory();
        this.validationDate = validationDate;
        this.validationObjectConsumer = validationObjectConsumer;
        this.policy = policy;
        this.reportContext = reportContext;
    }

    SignatureAttributesCreator(Date validationDate, Consumer<ValidationObjectType> validationObjectConsumer, ValidatePolicy policy, SigValReportFactory factory, ReportCreationContext reportContext) {
        this.validationDate = validationDate;
        this.validationObjectConsumer = validationObjectConsumer;
        this.policy = policy;
        this.factory = factory;
        this.reportContext = reportContext;
    }

    public org.etsi.uri._19102.v1_2_2.SignatureAttributesType visit(SignatureValidationResult signatureValidationResult) {
        this.addSignatureTimestamps(signatureValidationResult);
        if (signatureValidationResult instanceof AdESSignatureValidationResult) {
            this.transformSvpSignatureAttributes((AdESSignatureValidationResult)signatureValidationResult);
        }
        if (this.attributeList != null) {
            org.etsi.uri._19102.v1_2_2.SignatureAttributesType result = svrFactory.createSignatureAttributesType();
            result.getSigningTimeOrSigningCertificateOrDataObjectFormat().addAll(this.attributeList);
            return result;
        }
        return null;
    }

    public org.etsi.uri._19102.v1_2_2.SignatureAttributesType visit(CAdESSignatureValidationResultExt signatureValidationResult) {
        this.addArchiveTimestamps((AdESSignatureValidationResult)signatureValidationResult);
        return this.visit((SignatureValidationResult)signatureValidationResult);
    }

    public org.etsi.uri._19102.v1_2_2.SignatureAttributesType visit(OSCISignatureValidationResultExt osciSignatureValidationResult) {
        return null;
    }

    public org.etsi.uri._19102.v1_2_2.SignatureAttributesType visit(PAdESRevisionValidationResultExt pAdESRevisionValidationResult) {
        this.addArchiveTimestamps((AdESSignatureValidationResult)pAdESRevisionValidationResult);
        return this.visit((SignatureValidationResult)pAdESRevisionValidationResult);
    }

    public org.etsi.uri._19102.v1_2_2.SignatureAttributesType visit(XAdESSignatureValidationResultExt xAdESSignatureValidationResult) {
        this.addArchiveTimestamps((AdESSignatureValidationResult)xAdESSignatureValidationResult);
        return this.visit((SignatureValidationResult)xAdESSignatureValidationResult);
    }

    public org.etsi.uri._19102.v1_2_2.SignatureAttributesType visit(TimestampValidationResultExt timestampValidationResult) {
        return null;
    }

    public org.etsi.uri._19102.v1_2_2.SignatureAttributesType visit(PublicKeyCertificateValidationResultExt publicKeyCertificateValidationResult) {
        return null;
    }

    public org.etsi.uri._19102.v1_2_2.SignatureAttributesType visit(RevocationValueValidationResultExt revocationValueValidationResult) {
        return null;
    }

    public org.etsi.uri._19102.v1_2_2.SignatureAttributesType visit(AttributeCertificateValidationResultExt attributeCertificateValidationResult) {
        return null;
    }

    private void addSignatureTimestamps(SignatureValidationResult signatureValidationResult) {
        List signatureTimestampResults = signatureValidationResult.getSignatureTimestampResults();
        if (signatureTimestampResults != null) {
            for (TimestampValidationResult tvr : signatureTimestampResults) {
                TimestampReportCreator timestampReportCreator = this.factory.createTimestampReportCreator(tvr, this.validationDate, this.validationObjectConsumer, this.policy, this.reportContext);
                timestampReportCreator.createTimestampValidationObject();
            }
        }
    }

    private void addArchiveTimestamps(AdESSignatureValidationResult signatureValidationResult) {
        List archiveTimestampValidationResults = signatureValidationResult.getArchiveTimestampValidationResults();
        if (archiveTimestampValidationResults != null) {
            for (ArchiveTimestampValidationResult tvr : archiveTimestampValidationResults) {
                SATimestampType sat = svrFactory.createSATimestampType();
                sat.setSigned(Boolean.valueOf(false));
                Date generationTime = tvr.getGenerationTime();
                if (generationTime != null) {
                    sat.setTimeStampValue(ReportUtil.createXMLCalendar(generationTime));
                }
                ArchiveTimestampReportCreator timestampReportCreator = this.factory.createArchiveTimestampReportCreator(tvr, this.validationDate, this.validationObjectConsumer, this.policy, this.reportContext);
                ValidationObjectType timestampValidationObject = timestampReportCreator.createArchiveTimestampValidationObject();
                sat.getAttributeObject().add(this.createVOReference(timestampValidationObject));
                this.addAttribute(svrFactory.createSignatureAttributesTypeArchiveTimeStamp(sat));
            }
        }
    }

    private void addAttribute(JAXBElement<?> attribute) {
        if (this.attributeList == null) {
            this.attributeList = new ArrayList();
        }
        this.attributeList.add(attribute);
    }

    private VOReferenceType createVOReference(ValidationObjectType signingCertificateValidationObjectType) {
        VOReferenceType ref = svrFactory.createVOReferenceType();
        ref.getVOReference().add(signingCertificateValidationObjectType);
        return ref;
    }

    private void transformSvpSignatureAttributes(AdESSignatureValidationResult adesSignatureValidationResult) {
        TimeAttributeTypeTransformer transformer = new TimeAttributeTypeTransformer(svrFactory);
        transformer.append(new SubFilterTypeTransformer(svrFactory)).append(new SigPolicyIdentifierTypeTransformer(svrFactory)).append(new SignReasonTypeTransformer(svrFactory)).append(new SignerRoleTypeTransformer(svrFactory)).append(new SignerLocationTypeTransformer(svrFactory)).append(new RevIDListTypeTransformer(svrFactory)).append(new NameTypeTransformer(svrFactory)).append(new MessageDigestTypeTransformer(svrFactory)).append(new IntegerListTypeTransformer(svrFactory)).append(new FilterTypeTransformer(svrFactory)).append(new DataObjectFormatTypeTransformer(svrFactory)).append(new CounterSignatureTypeTransformer(svrFactory)).append(new ContactInfoTypeTransformer(svrFactory)).append(new CommitmentTypeIndicationTypeTransformer(svrFactory)).append(new CertIDListTypeTransformer(svrFactory)).append(new CertificateValuesTypeTransformer(svrFactory)).append(new RevocationValuesTypeTransformer(svrFactory)).append(new TimeStampValidationDataTypeTransformer(svrFactory)).append(new RenewedDigestsTypeTransformer(svrFactory));
        SignatureAttributesType svpSignatureAttributes = adesSignatureValidationResult.getSignatureAttributes();
        if (svpSignatureAttributes != null) {
            List svpAttrList = svpSignatureAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat();
            for (JAXBElement svpAttr : svpAttrList) {
                JAXBElement<?> svrAttr = transformer.transform((JAXBElement<? extends AttributeBaseType>)svpAttr, (SignatureValidationResult)adesSignatureValidationResult, this.reportContext);
                this.addAttribute(svrAttr);
            }
        }
    }
}

