/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.sig_val_report;

import de.governikus.csl.sig_val_report.BaseSignatureValidationReportCreator;
import de.governikus.csl.sig_val_report.ReportCreationContext;
import de.governikus.csl.sig_val_report.ReportUtil;
import de.governikus.csl.uom.validate.RevocationValueValidationResult;
import de.governikus.csl.uom.validate.ValidatePolicy;
import java.io.IOException;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import java.util.Date;
import java.util.function.Consumer;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.etsi.uri._19102.v1_2_2.SignatureValidationReportType;
import org.etsi.uri._19102.v1_2_2.VOReferenceType;
import org.etsi.uri._19102.v1_2_2.ValidationObjectRepresentationType;
import org.etsi.uri._19102.v1_2_2.ValidationObjectType;
import org.etsi.uri._19102.v1_2_2.ValidationReportDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevocationValueReportCreator
extends BaseSignatureValidationReportCreator<RevocationValueValidationResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RevocationValueReportCreator.class);

    public RevocationValueReportCreator(RevocationValueValidationResult signatureValidationResult, Date validationDate, Consumer<ValidationObjectType> validationObjectConsumer, ValidatePolicy policy, ReportCreationContext reportContext) {
        super(signatureValidationResult, validationDate, validationObjectConsumer, policy, reportContext);
    }

    public ValidationObjectType createSigningCertificateValidationObjectType() {
        ValidationObjectType vot = etsiSvrObjectFactory.createValidationObjectType();
        String id = ReportUtil.createId();
        vot.setId(id);
        this.validationObjectConsumer.accept(vot);
        ValidationObjectRepresentationType vor = etsiSvrObjectFactory.createValidationObjectRepresentationType();
        OCSPResp ocsp = ((RevocationValueValidationResult)this.signatureValidationResult).getOcsp();
        X509CRL crl = ((RevocationValueValidationResult)this.signatureValidationResult).getCrl();
        VOReferenceType revocationValueVORef = ReportUtil.createVOReference(vot);
        if (ocsp != null) {
            vot.setObjectType("urn:etsi:019102:validationObject:OCSPResponse");
            try {
                byte[] ocspResponseBytes = ocsp.getEncoded();
                vor.setBase64(ocspResponseBytes);
                vot.setValidationObjectRepresentation(vor);
                String ocspHash = ReportUtil.calculateSHA256(ocspResponseBytes);
                this.reportContext.addOCSPReference(ocspHash, revocationValueVORef);
            }
            catch (IOException e) {
                LOGGER.warn("Can't encode ocsp", (Throwable)e);
            }
        } else if (crl != null) {
            vot.setObjectType("urn:etsi:019102:validationObject:CRL");
            try {
                byte[] crlBytes = crl.getEncoded();
                vor.setBase64(crlBytes);
                vot.setValidationObjectRepresentation(vor);
                String crlHash = ReportUtil.calculateSHA256(crlBytes);
                this.reportContext.addCRLReference(crlHash, revocationValueVORef);
            }
            catch (CRLException e) {
                LOGGER.warn("Can't encode crl", (Throwable)e);
            }
        }
        vot.setValidationReport(this.createReport());
        ReportUtil.extendWithValidationObjectId(vot);
        return vot;
    }

    private SignatureValidationReportType createReport() {
        SignatureValidationReportType result = etsiSvrObjectFactory.createSignatureValidationReportType();
        result.setSignatureValidationStatus(this.createValidationStatus(false));
        result.setValidationConstraintsEvaluationReport(this.createValidationConstraintsEvaluationReport());
        result.setValidationTimeInfo(this.createValidationTimeInfo());
        return result;
    }

    @Override
    protected ValidationReportDataType createValidationReportData() {
        ValidationReportDataType result = etsiSvrObjectFactory.createValidationReportDataType();
        result.setCryptoInformation(this.createCryptoInformation());
        result.setCertificateChain(this.createCertificateChain());
        result.setTrustAnchor(this.createTrustAnchor());
        return result;
    }
}

