/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.sig_val_report;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.UUID;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.bouncycastle.util.encoders.Hex;
import org.etsi.uri._19102.v1_2_2.CryptoInformationType;
import org.etsi.uri._19102.v1_2_2.ObjectFactory;
import org.etsi.uri._19102.v1_2_2.SignatureIdentifierType;
import org.etsi.uri._19102.v1_2_2.SignatureValidationReportType;
import org.etsi.uri._19102.v1_2_2.VOReferenceType;
import org.etsi.uri._19102.v1_2_2.ValidationObjectType;
import org.etsi.uri._19102.v1_2_2.ValidationReportDataType;
import org.etsi.uri._19102.v1_2_2.ValidationStatusType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportUtil.class);
    private static final String UUID_PREFIX = "uuid_";
    private static final String PREFIX_URN_OID = "urn:oid:";
    private static final ObjectFactory svrFactory = new ObjectFactory();
    private static DatatypeFactory datatypeFactory;

    private ReportUtil() {
    }

    public static XMLGregorianCalendar createXMLCalendar(Date d) {
        GregorianCalendar gCalendar = new GregorianCalendar();
        gCalendar.setTime(d);
        return datatypeFactory.newXMLGregorianCalendar(gCalendar);
    }

    public static String createId() {
        return UUID_PREFIX + UUID.randomUUID().toString();
    }

    public static String createUrnFromOid(String oid) {
        return PREFIX_URN_OID + oid;
    }

    public static void extendWithValidationObjectId(ValidationObjectType objectToExtend) {
        SignatureValidationReportType validationReport = objectToExtend.getValidationReport();
        ReportUtil.extendWithValidationObjectId(validationReport, objectToExtend);
    }

    public static void extendWithValidationObjectId(SignatureValidationReportType objectToExtend) {
        SignatureIdentifierType sigId = objectToExtend.getSignatureIdentifier();
        ReportUtil.extendWithValidationObjectId(objectToExtend, sigId);
    }

    private static void extendWithValidationObjectId(SignatureValidationReportType objectToExtend, Object objectToReference) {
        ValidationStatusType signatureValidationStatus = objectToExtend.getSignatureValidationStatus();
        List validationReportData = signatureValidationStatus.getAssociatedValidationReportData();
        for (ValidationReportDataType data : validationReportData) {
            CryptoInformationType cryptoInformation = data.getCryptoInformation();
            if (cryptoInformation == null) continue;
            VOReferenceType ref = ReportUtil.createVOReference(objectToReference);
            cryptoInformation.setValidationObjectId(ref);
        }
    }

    public static String calculateSHA256(byte[] dataToHash) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-256");
            byte[] hashValue = md.digest(dataToHash);
            return Hex.toHexString((byte[])hashValue);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("Failed to initialize message digest for algorithm SHA-256");
            return "";
        }
    }

    public static VOReferenceType createVOReference(Object validationObject) {
        VOReferenceType ref = svrFactory.createVOReferenceType();
        ref.getVOReference().add(validationObject);
        return ref;
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            LOGGER.error("Can't create DatatypeFactory", (Throwable)e);
        }
    }
}

