/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.sig_val_report;

import de.governikus.csl.sig_val_report.ReportCreationContext;
import de.governikus.csl.sig_val_report.SigValReportFactory;
import de.governikus.csl.sig_val_report.SignatureValidationReportCreator;
import de.governikus.csl.svp.ContainerValidationResultExt;
import de.governikus.csl.svp.ObjectValidationResultExt;
import de.governikus.csl.svp.ObjectValidationResultVisitor;
import de.governikus.csl.svp.asic.AsicDocumentValidationResultExt;
import de.governikus.csl.svp.demail.AcknowledgeMessageValidationResultExt;
import de.governikus.csl.svp.demail.DeMailConfirmationValidationResultExt;
import de.governikus.csl.svp.demail.DeMailMimeDocumentValidationResultExt;
import de.governikus.csl.svp.osci.OSCIDocumentValidationResultExt;
import de.governikus.csl.svp.smime.SMIMECDocumentValidationResultExt;
import de.governikus.csl.uom.validate.EvaluatedValidatePolicy;
import de.governikus.csl.uom.validate.ObjectValidationResult;
import de.governikus.csl.uom.validate.SignatureValidationResult;
import de.governikus.csl.uom.validate.ValidatePolicy;
import de.governikus.csl.uom.validate.ValidateResponse;
import java.util.List;
import java.util.Map;
import org.etsi.uri._19102.v1_2_2.ObjectFactory;
import org.etsi.uri._19102.v1_2_2.SignatureValidationReportType;
import org.etsi.uri._19102.v1_2_2.ValidationObjectListType;
import org.etsi.uri._19102.v1_2_2.ValidationObjectType;
import org.etsi.uri._19102.v1_2_2.ValidationReportType;

public class ObjectValidationResultProcessor
implements ObjectValidationResultVisitor<Void> {
    private ObjectFactory objectFactory = new ObjectFactory();
    private Map<Integer, ? extends EvaluatedValidatePolicy> policies;
    private ValidationReportType validationReport;
    private ValidateResponse validateResponse;
    private SigValReportFactory factory;

    public ObjectValidationResultProcessor(ValidationReportType validationReport, ValidateResponse validateResponse) {
        this.validationReport = validationReport;
        this.validateResponse = validateResponse;
        this.factory = new SigValReportFactory();
    }

    ObjectValidationResultProcessor(ValidationReportType validationReport, ValidateResponse validateResponse, SigValReportFactory factory) {
        this.validationReport = validationReport;
        this.validateResponse = validateResponse;
        this.factory = factory;
    }

    public Void visit(SMIMECDocumentValidationResultExt smimeDocumentValidationResult) {
        return this.visit((ContainerValidationResultExt)smimeDocumentValidationResult);
    }

    public Void visit(OSCIDocumentValidationResultExt osciDocumentValidationResult) {
        return this.visit((ContainerValidationResultExt)osciDocumentValidationResult);
    }

    public Void visit(AcknowledgeMessageValidationResultExt acknowledgeMessageValidationResult) {
        return this.visit((ContainerValidationResultExt)acknowledgeMessageValidationResult);
    }

    public Void visit(DeMailConfirmationValidationResultExt deMailConfirmationValidationResult) {
        return this.visit((ContainerValidationResultExt)deMailConfirmationValidationResult);
    }

    public Void visit(DeMailMimeDocumentValidationResultExt deMailMimeDocumentValidationResult) {
        return this.visit((ObjectValidationResult)deMailMimeDocumentValidationResult);
    }

    public Void visit(AsicDocumentValidationResultExt asicDocumentValidationResult) {
        return this.visit((ContainerValidationResultExt)asicDocumentValidationResult);
    }

    public Void visit(ContainerValidationResultExt containerValidationResult) {
        this.visit((ObjectValidationResult)containerValidationResult);
        List resultsForContainedObjects = containerValidationResult.getResultsForContainedObjects();
        if (resultsForContainedObjects != null) {
            for (ObjectValidationResult ovr : resultsForContainedObjects) {
                this.process(ovr);
            }
        }
        return null;
    }

    public Void visit(ObjectValidationResult objectValidationResult) {
        List signatureValidationResults;
        List includedFileValidationResults;
        Map policiesFromResult = objectValidationResult.getPolicies();
        if (policiesFromResult != null && !policiesFromResult.isEmpty()) {
            if (this.policies != null) {
                throw new IllegalStateException("Duplicate PolicyMaps found");
            }
            this.policies = policiesFromResult;
        }
        if ((includedFileValidationResults = objectValidationResult.getIncludedFileValidationResults()) != null) {
            for (ObjectValidationResult ovr : includedFileValidationResults) {
                this.process(ovr);
            }
        }
        if ((signatureValidationResults = objectValidationResult.getSignatureValidationResults()) == null) {
            return null;
        }
        for (SignatureValidationResult svr : signatureValidationResults) {
            int policyReference = svr.getPolicyReference();
            ValidatePolicy policy = null;
            if (policyReference > 0) {
                policy = this.policies.get(policyReference).getPolicy();
            }
            ReportCreationContext reportContext = new ReportCreationContext();
            SignatureValidationReportCreator creator = this.factory.createSignatureValidationReportCreator(svr, this.validateResponse.getValidationTime(), this::addValidationObject, policy, true, reportContext);
            SignatureValidationReportType report = creator.createReport();
            this.validationReport.getSignatureValidationReport().add(report);
        }
        return null;
    }

    private void process(ObjectValidationResult documentValidationResult) {
        if (documentValidationResult instanceof ObjectValidationResultExt) {
            ((ObjectValidationResultExt)documentValidationResult).process((ObjectValidationResultVisitor)this);
        } else {
            this.visit(documentValidationResult);
        }
    }

    private void addValidationObject(ValidationObjectType vo) {
        ValidationObjectListType signatureValidationObjects = this.validationReport.getSignatureValidationObjects();
        if (signatureValidationObjects == null) {
            signatureValidationObjects = this.objectFactory.createValidationObjectListType();
            this.validationReport.setSignatureValidationObjects(signatureValidationObjects);
        }
        signatureValidationObjects.getValidationObject().add(vo);
    }
}

