/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.sig_val_report;

import de.governikus.csl.svp.AttributeCertificateValidationResultExt;
import de.governikus.csl.svp.CertificateValidationResultExt;
import de.governikus.csl.svp.PublicKeyCertificateValidationResultExt;
import de.governikus.csl.svp.RevocationValueValidationResultExt;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.svp.SignatureValidationResultVisitor;
import de.governikus.csl.svp.TimestampValidationResultExt;
import de.governikus.csl.svp.cades.CAdESSignatureValidationResultExt;
import de.governikus.csl.svp.osci.OSCISignatureValidationResultExt;
import de.governikus.csl.svp.pades.PAdESRevisionValidationResultExt;
import de.governikus.csl.svp.xades.XAdESSignatureValidationResultExt;
import de.governikus.csl.uom.validate.AlgorithmValidityResult;
import de.governikus.csl.uom.validate.SignatureValidationResult;
import de.governikus.csl.uom.validate.commons.CumulatedValidationResult;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.uom.validate.commons.NestedResultCumulationInstruction;
import de.governikus.csl.uom.validate.commons.ValidationMessageCode;
import de.governikus.csl.validate.svp.ValidationResult;
import java.util.ArrayList;
import java.util.List;
import org.etsi.uri._19102.v1_2_2.ConstraintStatusType;
import org.etsi.uri._19102.v1_2_2.IndividualValidationConstraintReportType;
import org.etsi.uri._19102.v1_2_2.ObjectFactory;
import org.etsi.uri._19102.v1_2_2.ValidationStatusType;

public class IndividualValidationConstraintReportCreator
implements SignatureValidationResultVisitor<List<IndividualValidationConstraintReportType>> {
    private ObjectFactory objectFactory = new ObjectFactory();

    public List<IndividualValidationConstraintReportType> visit(SignatureValidationResult signatureValidationResult) {
        ArrayList<IndividualValidationConstraintReportType> result = new ArrayList<IndividualValidationConstraintReportType>();
        result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/sig_cert_usage", signatureValidationResult.getSigningCertificateUsageCheck()));
        result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/sig_timestamp_delay", signatureValidationResult.getTimestampDelayCheck()));
        result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/sig_timestamp_ordering", signatureValidationResult.getTimestampOrderingCheck()));
        result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/sig_parse_error", signatureValidationResult.getParseError()));
        result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/sig_claimed_signing_time", signatureValidationResult.getClaimedSigningTimeCheck()));
        result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/sig_math", signatureValidationResult.getSignatureMathCheck()));
        result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/sig_alg_poe", signatureValidationResult.getSignatureAlgorithmValidityAtBestPOE()));
        result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/sig_alg_claimed_signing_time", signatureValidationResult.getSignatureAlgorithmValidityAtClaimedSigningTime()));
        result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/sig_alg_validation_date", signatureValidationResult.getSignatureAlgorithmValidityAtValidationDate()));
        return result;
    }

    public List<IndividualValidationConstraintReportType> visit(CAdESSignatureValidationResultExt signatureValidationResult) {
        Object result = this.visit((SignatureValidationResult)signatureValidationResult);
        result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/cades_signer_info_issues", signatureValidationResult.getSignerInfoValidationResult()));
        return result;
    }

    public List<IndividualValidationConstraintReportType> visit(OSCISignatureValidationResultExt osciSignatureValidationResult) {
        Object result = this.visit((SignatureValidationResult)osciSignatureValidationResult);
        result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/osci_all_content_signed", (de.governikus.csl.uom.validate.commons.ValidationResult)osciSignatureValidationResult.getAllContentSignedCheck()));
        return result;
    }

    public List<IndividualValidationConstraintReportType> visit(PAdESRevisionValidationResultExt pAdESRevisionValidationResult) {
        Object result = this.visit((SignatureValidationResult)pAdESRevisionValidationResult);
        result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/pades_signature_size", (de.governikus.csl.uom.validate.commons.ValidationResult)pAdESRevisionValidationResult.getSignatureSizeCheck()));
        result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/pades_enveloped_content", (de.governikus.csl.uom.validate.commons.ValidationResult)pAdESRevisionValidationResult.getEnvelopedContent()));
        return result;
    }

    public List<IndividualValidationConstraintReportType> visit(XAdESSignatureValidationResultExt xAdESSignatureValidationResult) {
        Object result = this.visit((SignatureValidationResult)xAdESSignatureValidationResult);
        result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/xades_data_format", (de.governikus.csl.uom.validate.commons.ValidationResult)xAdESSignatureValidationResult.getDataFormatCheck()));
        result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/xades_signing_time", (de.governikus.csl.uom.validate.commons.ValidationResult)xAdESSignatureValidationResult.getSigningTimeCheck()));
        result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/xades_baseline_prohibited_elements", (de.governikus.csl.uom.validate.commons.ValidationResult)xAdESSignatureValidationResult.getBaselineProhibitedElementsCheck()));
        result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/xades_specification_conformity", (de.governikus.csl.uom.validate.commons.ValidationResult)xAdESSignatureValidationResult.getSpecificationConformityCheck()));
        result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/xades_timestamp_order", (de.governikus.csl.uom.validate.commons.ValidationResult)xAdESSignatureValidationResult.getXadesTimestampOrderCheck()));
        result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/xades_references_ambiguous", (de.governikus.csl.uom.validate.commons.ValidationResult)xAdESSignatureValidationResult.getSignatureReferencesAmbiguous()));
        return result;
    }

    public List<IndividualValidationConstraintReportType> visit(TimestampValidationResultExt timestampValidationResult) {
        Object result = this.visit((SignatureValidationResult)timestampValidationResult);
        result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/tsp_message_imprint", timestampValidationResult.getImprintCheck()));
        return result;
    }

    public List<IndividualValidationConstraintReportType> visit(CertificateValidationResultExt certificateValidationResult) {
        Object result = this.visit((SignatureValidationResult)certificateValidationResult);
        result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/cert_revocation_trust", certificateValidationResult.getRevocationTrustCheckResult()));
        result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/cert_trustcenter_reliability", certificateValidationResult.getTrustCenterReliability()));
        result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/cert_validity", certificateValidationResult.getValidityCheck()));
        result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/cert_chain", certificateValidationResult.getCertChainCheck()));
        boolean isNotValidityAssuredShortTerm = true;
        de.governikus.csl.uom.validate.commons.ValidationResult revocationStatusCheck = certificateValidationResult.getRevocationStatusCheck();
        if (revocationStatusCheck != null && revocationStatusCheck.getMajor() == MajorTotalResult.NOT_VALIDATED) {
            List messageCodes = revocationStatusCheck.getMessages();
            for (ValidationMessageCode messageCode : messageCodes) {
                String messageCodeString = messageCode.getMessageCode();
                if (!"revocation_values_signer_certificate_no_check".equals(messageCodeString)) continue;
                result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/cert_revocation_status", "https://www.governikus.de/val-uri/validation-constraints/validity_assured_short_term_cert"));
                ValidationResult validityAssuredShortTermResult = SVPFactory.createResultOk();
                result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/validity_assured_short_term_cert", (de.governikus.csl.uom.validate.commons.ValidationResult)validityAssuredShortTermResult));
                isNotValidityAssuredShortTerm = false;
                break;
            }
        }
        if (isNotValidityAssuredShortTerm) {
            result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/cert_revocation_status", certificateValidationResult.getRevocationStatusCheck()));
            ValidationResult validityAssuredShortTermResult = new ValidationResult();
            validityAssuredShortTermResult.setMajor(MajorTotalResult.NOT_VALIDATED);
            result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/validity_assured_short_term_cert", (de.governikus.csl.uom.validate.commons.ValidationResult)validityAssuredShortTermResult));
        }
        return result;
    }

    public List<IndividualValidationConstraintReportType> visit(PublicKeyCertificateValidationResultExt publicKeyCertificateValidationResult) {
        List<IndividualValidationConstraintReportType> result = this.visit((CertificateValidationResultExt)publicKeyCertificateValidationResult);
        result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/x509_extension", publicKeyCertificateValidationResult.getExtensionCheck()));
        result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/x509_tl_validity", publicKeyCertificateValidationResult.getTlValidityCheck()));
        result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/x509_cert_chain_references_conformance", publicKeyCertificateValidationResult.getCertChainReferencesConformance()));
        return result;
    }

    public List<IndividualValidationConstraintReportType> visit(RevocationValueValidationResultExt revocationValueValidationResult) {
        Object result = this.visit((SignatureValidationResult)revocationValueValidationResult);
        result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/rev_freshness", revocationValueValidationResult.getFreshnessCheckResult()));
        result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/rev_cert_hash", revocationValueValidationResult.getCertHashCheckResult()));
        result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/rev_crl_issuer", revocationValueValidationResult.getCRLIssuerCheckResult()));
        result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/rev_trust", revocationValueValidationResult.getRevocationValueTrustCheckResult()));
        result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/rev_update_value", revocationValueValidationResult.getUpdateValueCheckResult()));
        return result;
    }

    public List<IndividualValidationConstraintReportType> visit(AttributeCertificateValidationResultExt attributeCertificateValidationResult) {
        List<IndividualValidationConstraintReportType> result = this.visit((CertificateValidationResultExt)attributeCertificateValidationResult);
        result.add(this.createIndividualValidationConstraintReport("https://www.governikus.de/val-uri/validation-constraints/attr_base_certificate", attributeCertificateValidationResult.getBaseCertificateCheck()));
        return result;
    }

    private IndividualValidationConstraintReportType createIndividualValidationConstraintReport(String constraintURL, AlgorithmValidityResult algorithmValidityResult) {
        IndividualValidationConstraintReportType result = this.objectFactory.createIndividualValidationConstraintReportType();
        result.setValidationConstraintIdentifier(constraintURL);
        result.setConstraintStatus(this.createConstraintStatus(algorithmValidityResult));
        result.setValidationStatus(this.createValidationStatus(algorithmValidityResult));
        return result;
    }

    private ValidationStatusType createValidationStatus(AlgorithmValidityResult algorithmValidityResult) {
        if (algorithmValidityResult == null) {
            return null;
        }
        ValidationStatusType result = null;
        CumulatedValidationResult overallResult = algorithmValidityResult.getOverallResult(NestedResultCumulationInstruction.INCLUDE_VALIDATION_MESSAGES);
        if (MajorTotalResult.NOT_VALIDATED != overallResult.getMajor()) {
            result = this.objectFactory.createValidationStatusType();
            result.setMainIndication(overallResult.getMajor().getTS119102ValidationConstraintUri());
            MinorResult minor = overallResult.getMinor();
            if (minor != null) {
                result.getSubIndication().add(minor.getTS119102Uri());
            }
        }
        return result;
    }

    private ConstraintStatusType createConstraintStatus(AlgorithmValidityResult algorithmValidityResult) {
        ConstraintStatusType result = this.objectFactory.createConstraintStatusType();
        if (algorithmValidityResult == null || algorithmValidityResult.getSignatureAlgorithmValidationResult().getMajor() == MajorTotalResult.NOT_VALIDATED) {
            result.setStatus("urn:etsi:019102:constraintStatus:disabled");
        } else {
            result.setStatus("urn:etsi:019102:constraintStatus:applied");
        }
        return result;
    }

    private IndividualValidationConstraintReportType createIndividualValidationConstraintReport(String constraintURL, de.governikus.csl.uom.validate.commons.ValidationResult validationResult) {
        IndividualValidationConstraintReportType result = this.objectFactory.createIndividualValidationConstraintReportType();
        result.setValidationConstraintIdentifier(constraintURL);
        result.setConstraintStatus(this.createConstraintStatus(validationResult));
        result.setValidationStatus(this.createValidationStatus(validationResult));
        return result;
    }

    private IndividualValidationConstraintReportType createIndividualValidationConstraintReport(String constraintURL, String overridingConstraintURI) {
        IndividualValidationConstraintReportType result = this.objectFactory.createIndividualValidationConstraintReportType();
        result.setValidationConstraintIdentifier(constraintURL);
        ConstraintStatusType constraintStatus = this.objectFactory.createConstraintStatusType();
        constraintStatus.setStatus("urn:etsi:019102:constraintStatus:overridden");
        constraintStatus.setOverriddenBy(overridingConstraintURI);
        result.setConstraintStatus(constraintStatus);
        return result;
    }

    private ValidationStatusType createValidationStatus(de.governikus.csl.uom.validate.commons.ValidationResult validationResult) {
        if (validationResult == null) {
            return null;
        }
        ValidationStatusType result = null;
        MajorTotalResult major = validationResult.getMajor();
        if (MajorTotalResult.NOT_VALIDATED != major) {
            result = this.objectFactory.createValidationStatusType();
            result.setMainIndication(validationResult.getMajor().getTS119102ValidationConstraintUri());
            MinorResult minor = validationResult.getMinor();
            if (minor != null) {
                result.getSubIndication().add(minor.getTS119102Uri());
            }
        }
        return result;
    }

    private ConstraintStatusType createConstraintStatus(de.governikus.csl.uom.validate.commons.ValidationResult validationResult) {
        ConstraintStatusType result = this.objectFactory.createConstraintStatusType();
        if (validationResult == null || validationResult.getMajor() == MajorTotalResult.NOT_VALIDATED) {
            result.setStatus("urn:etsi:019102:constraintStatus:disabled");
        } else {
            result.setStatus("urn:etsi:019102:constraintStatus:applied");
        }
        return result;
    }
}

