/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.sig_val_report;

import de.bos_bremen.algorithm_identifier.SignatureAlgorithm;
import de.governikus.csl.sig_val_report.ReportUtil;
import de.governikus.csl.uom.validate.AlgorithmValidityResult;
import de.governikus.csl.uom.validate.SignatureValidationResult;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.NestedResultCumulationInstruction;
import de.governikus.csl.validate.svp.SignatureAlgorithmParameterList;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.etsi.uri._19102.v1_2_2.CryptoInformationType;
import org.etsi.uri._19102.v1_2_2.TypedDataType;

public class CryptoInformationCreator {
    private static final String URN_OID_PREFIX = "urn:oid:";

    public CryptoInformationType create(SignatureValidationResult signatureValidationResult) {
        CryptoInformationType result = null;
        if (signatureValidationResult.getSignatureAlgorithm() != null) {
            result = new CryptoInformationType();
            result.setAlgorithm(this.getAlgorithmUri(signatureValidationResult));
            result.setSecureAlgorithm(this.isUsedAlgorithmValid(signatureValidationResult));
            result.setAlgorithmParameters(this.createAlgorithmParameters(signatureValidationResult));
            result.setNotAfter(this.getMinAlgorithmValidity(signatureValidationResult));
        }
        return result;
    }

    private TypedDataType createAlgorithmParameters(SignatureValidationResult signatureValidationResult) {
        List signatureAlgorithmParameters = signatureValidationResult.getSignatureAlgorithmParameters();
        if (signatureAlgorithmParameters == null || signatureAlgorithmParameters.isEmpty()) {
            return null;
        }
        TypedDataType result = new TypedDataType();
        result.setType("http://www.governikus.de/csl/svp#SignatureAlgorithmParameterList");
        SignatureAlgorithmParameterList parameterList = new SignatureAlgorithmParameterList();
        parameterList.getAlgorithmParameters().addAll(signatureAlgorithmParameters);
        result.setValue((Object)parameterList);
        return result;
    }

    private XMLGregorianCalendar getMinAlgorithmValidity(SignatureValidationResult signatureValidationResult) {
        Date min = signatureValidationResult.getSignatureAlgorithmExpirationDateSign();
        Date signatureAlgorithmExpirationDateVal = signatureValidationResult.getSignatureAlgorithmExpirationDateVal();
        if (signatureAlgorithmExpirationDateVal != null && (min == null || min.compareTo(signatureAlgorithmExpirationDateVal) > 0)) {
            min = signatureAlgorithmExpirationDateVal;
        }
        if (min != null) {
            return ReportUtil.createXMLCalendar(min);
        }
        return null;
    }

    private boolean isUsedAlgorithmValid(SignatureValidationResult signatureValidationResult) {
        return this.isValid(signatureValidationResult.getSignatureAlgorithmValidityAtBestPOE()) && this.isValid(signatureValidationResult.getSignatureAlgorithmValidityAtClaimedSigningTime()) && this.isValid(signatureValidationResult.getSignatureAlgorithmValidityAtValidationDate());
    }

    private boolean isValid(AlgorithmValidityResult algorithmValidity) {
        if (algorithmValidity == null) {
            return true;
        }
        MajorTotalResult major = algorithmValidity.getOverallResult(NestedResultCumulationInstruction.INCLUDE_MAJOR).getMajor();
        return major == MajorTotalResult.TOTAL_PASSED || major == MajorTotalResult.NOT_VALIDATED;
    }

    private String getAlgorithmUri(SignatureValidationResult signatureValidationResult) {
        SignatureAlgorithm signatureAlgorithm = signatureValidationResult.getSignatureAlgorithm();
        String algorithmUri = signatureAlgorithm.getURI();
        if (algorithmUri == null) {
            algorithmUri = URN_OID_PREFIX + signatureAlgorithm.getOID();
        }
        return algorithmUri;
    }
}

