/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.sig_val_report;

import de.governikus.csl.sig_val_report.BaseSignatureValidationReportCreator;
import de.governikus.csl.sig_val_report.ReportCreationContext;
import de.governikus.csl.sig_val_report.ReportUtil;
import de.governikus.csl.sig_val_report.RevocationValueReportCreator;
import de.governikus.csl.sig_val_report.SigValReportFactory;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.PublicKeyCertificateValidationResult;
import de.governikus.csl.uom.validate.RevocationValueValidationResult;
import de.governikus.csl.uom.validate.ValidatePolicy;
import de.governikus.csl.uom.validate.commons.CRLReason;
import de.governikus.csl.uom.validate.commons.CumulatedValidationResult;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.NestedResultCumulationInstruction;
import de.governikus.csl.uom.validate.commons.RevocationStatus;
import java.security.cert.CertificateEncodingException;
import java.util.Date;
import java.util.function.Consumer;
import org.etsi.uri._19102.v1_2_2.RevocationStatusInformationType;
import org.etsi.uri._19102.v1_2_2.SignatureValidationReportType;
import org.etsi.uri._19102.v1_2_2.VOReferenceType;
import org.etsi.uri._19102.v1_2_2.ValidationObjectRepresentationType;
import org.etsi.uri._19102.v1_2_2.ValidationObjectType;
import org.etsi.uri._19102.v1_2_2.ValidationReportDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateValidationReportCreator
extends BaseSignatureValidationReportCreator<PublicKeyCertificateValidationResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CertificateValidationReportCreator.class);
    private ValidationObjectType vot;

    public CertificateValidationReportCreator(PublicKeyCertificateValidationResult signatureValidationResult, Date validationDate, Consumer<ValidationObjectType> validationObjectConsumer, ValidatePolicy policy, ReportCreationContext reportContext) {
        super(signatureValidationResult, validationDate, validationObjectConsumer, policy, reportContext);
    }

    protected CertificateValidationReportCreator(PublicKeyCertificateValidationResult signatureValidationResult, Date validationDate, Consumer<ValidationObjectType> validationObjectConsumer, ValidatePolicy policy, SigValReportFactory factory, ReportCreationContext reportContext) {
        super(signatureValidationResult, validationDate, validationObjectConsumer, policy, factory, reportContext);
    }

    public ValidationObjectType createSigningCertificateValidationObjectType() {
        X509CertificateImpl cert = ((PublicKeyCertificateValidationResult)this.signatureValidationResult).getCert();
        this.vot = etsiSvrObjectFactory.createValidationObjectType();
        String id = ReportUtil.createId();
        this.vot.setId(id);
        this.validationObjectConsumer.accept(this.vot);
        this.vot.setObjectType("urn:etsi:019102:validationObject:certificate");
        byte[] certBytes = null;
        ValidationObjectRepresentationType vor = etsiSvrObjectFactory.createValidationObjectRepresentationType();
        try {
            if (cert != null) {
                certBytes = cert.getEncoded();
                vor.setBase64(certBytes);
            }
            this.vot.setValidationObjectRepresentation(vor);
        }
        catch (CertificateEncodingException e) {
            LOGGER.warn("Can't encode certificate", (Throwable)e);
        }
        CumulatedValidationResult overallResult = ((PublicKeyCertificateValidationResult)this.signatureValidationResult).getOverallResult(NestedResultCumulationInstruction.INCLUDE_MAJOR);
        if (overallResult.getMajor() != MajorTotalResult.NOT_VALIDATED) {
            this.vot.setValidationReport(this.createReport());
            ReportUtil.extendWithValidationObjectId(this.vot);
            if (certBytes != null) {
                String certHash = ReportUtil.calculateSHA256(certBytes);
                VOReferenceType certVORef = ReportUtil.createVOReference(this.vot);
                this.reportContext.addCertificateReference(certHash, certVORef);
            }
        }
        return this.vot;
    }

    private SignatureValidationReportType createReport() {
        SignatureValidationReportType result = etsiSvrObjectFactory.createSignatureValidationReportType();
        result.setSignatureValidationStatus(this.createValidationStatus(false));
        result.setValidationConstraintsEvaluationReport(this.createValidationConstraintsEvaluationReport());
        result.setValidationTimeInfo(this.createValidationTimeInfo());
        return result;
    }

    @Override
    protected ValidationReportDataType createValidationReportData() {
        ValidationReportDataType result = etsiSvrObjectFactory.createValidationReportDataType();
        result.setCryptoInformation(this.createCryptoInformation());
        result.setRevocationStatusInformation(this.createRevocationStatusInformation());
        return result;
    }

    private RevocationStatusInformationType createRevocationStatusInformation() {
        RevocationValueValidationResult revocationValueValidationResult = ((PublicKeyCertificateValidationResult)this.signatureValidationResult).getRevocationValueValidationResult();
        if (revocationValueValidationResult == null || revocationValueValidationResult.getStatus() != RevocationStatus.REVOKED) {
            return null;
        }
        RevocationStatusInformationType result = etsiSvrObjectFactory.createRevocationStatusInformationType();
        Date revocationDate = ((PublicKeyCertificateValidationResult)this.signatureValidationResult).getRevocationDate();
        if (revocationDate != null) {
            result.setRevocationTime(ReportUtil.createXMLCalendar(revocationDate));
        }
        result.setRevocationReason(this.getRevocationReason());
        result.setValidationObjectId(ReportUtil.createVOReference(this.vot));
        RevocationValueReportCreator child = this.factory.createRevocationValueReportCreator(revocationValueValidationResult, this.validationDate, this.validationObjectConsumer, this.policy, this.reportContext);
        ValidationObjectType createSigningCertificateValidationObjectType = child.createSigningCertificateValidationObjectType();
        result.setRevocationObject(ReportUtil.createVOReference(createSigningCertificateValidationObjectType));
        return result;
    }

    private String getRevocationReason() {
        CRLReason revocationReason = ((PublicKeyCertificateValidationResult)this.signatureValidationResult).getRevocationReason();
        if (revocationReason == null) {
            return null;
        }
        return revocationReason.getTs119102Uri();
    }
}

