/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.sig_val_report;

import de.governikus.csl.sig_val_report.CertificateValidationReportCreator;
import de.governikus.csl.sig_val_report.CryptoInformationCreator;
import de.governikus.csl.sig_val_report.IndividualValidationConstraintReportCreator;
import de.governikus.csl.sig_val_report.ReportCreationContext;
import de.governikus.csl.sig_val_report.ReportUtil;
import de.governikus.csl.sig_val_report.SigValReportFactory;
import de.governikus.csl.sig_val_report.SignatureAttributesCreator;
import de.governikus.csl.sig_val_report.SignatureQualityCreator;
import de.governikus.csl.svp.SignatureValidationResultExt;
import de.governikus.csl.svp.SignatureValidationResultVisitor;
import de.governikus.csl.svr.additionaltypes.govsvrextension.ValidationMessageURIType;
import de.governikus.csl.uom.validate.PublicKeyCertificateValidationResult;
import de.governikus.csl.uom.validate.SignatureValidationResult;
import de.governikus.csl.uom.validate.ValidatePolicy;
import de.governikus.csl.uom.validate.ValidityModelDeterminationResult;
import de.governikus.csl.uom.validate.commons.CumulatedValidationResult;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.uom.validate.commons.NestedResultCumulationInstruction;
import de.governikus.csl.uom.validate.commons.SignatureClass;
import de.governikus.csl.uom.validate.commons.ValidationMessageCode;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import javax.xml.bind.JAXBElement;
import org.etsi.uri._19102.v1_2_2.AdditionalValidationReportDataType;
import org.etsi.uri._19102.v1_2_2.CertificateChainType;
import org.etsi.uri._19102.v1_2_2.CryptoInformationType;
import org.etsi.uri._19102.v1_2_2.IndividualValidationConstraintReportType;
import org.etsi.uri._19102.v1_2_2.ObjectFactory;
import org.etsi.uri._19102.v1_2_2.POEType;
import org.etsi.uri._19102.v1_2_2.SignatureAttributesType;
import org.etsi.uri._19102.v1_2_2.SignatureIdentifierType;
import org.etsi.uri._19102.v1_2_2.SignatureQualityType;
import org.etsi.uri._19102.v1_2_2.SignatureValidationProcessType;
import org.etsi.uri._19102.v1_2_2.SignerInformationType;
import org.etsi.uri._19102.v1_2_2.TypedDataType;
import org.etsi.uri._19102.v1_2_2.VOReferenceType;
import org.etsi.uri._19102.v1_2_2.ValidationConstraintsEvaluationReportType;
import org.etsi.uri._19102.v1_2_2.ValidationObjectType;
import org.etsi.uri._19102.v1_2_2.ValidationReportDataType;
import org.etsi.uri._19102.v1_2_2.ValidationStatusType;
import org.etsi.uri._19102.v1_2_2.ValidationTimeInfoType;
import org.w3._2000._09.xmldsig.SignatureValueType;

public class BaseSignatureValidationReportCreator<T extends SignatureValidationResult> {
    protected static ObjectFactory etsiSvrObjectFactory = new ObjectFactory();
    protected static de.governikus.csl.svr.additionaltypes.govsvrextension.ObjectFactory svrExtensionObjectFactory = new de.governikus.csl.svr.additionaltypes.govsvrextension.ObjectFactory();
    protected Date validationDate;
    protected ValidatePolicy policy;
    protected T signatureValidationResult;
    protected Consumer<ValidationObjectType> validationObjectConsumer;
    protected ValidationObjectType signingCertificateObjectType;
    protected ValidationObjectType trustAnchor;
    protected SigValReportFactory factory;
    protected ReportCreationContext reportContext;

    protected BaseSignatureValidationReportCreator(T signatureValidationResult, Date validationDate, Consumer<ValidationObjectType> validationObjectConsumer, ValidatePolicy policy, ReportCreationContext reportContext) {
        this.signatureValidationResult = signatureValidationResult;
        this.validationDate = validationDate;
        this.validationObjectConsumer = validationObjectConsumer;
        this.policy = policy;
        this.factory = new SigValReportFactory();
        this.reportContext = reportContext;
    }

    protected BaseSignatureValidationReportCreator(T signatureValidationResult, Date validationDate, Consumer<ValidationObjectType> validationObjectConsumer, ValidatePolicy policy, SigValReportFactory factory, ReportCreationContext reportContext) {
        this.signatureValidationResult = signatureValidationResult;
        this.validationDate = validationDate;
        this.validationObjectConsumer = validationObjectConsumer;
        this.policy = policy;
        this.factory = factory;
        this.reportContext = reportContext;
    }

    protected SignatureIdentifierType createSignatureIdentifier() {
        SignatureIdentifierType result = etsiSvrObjectFactory.createSignatureIdentifierType();
        byte[] signatureValue = this.signatureValidationResult.getSignatureValue();
        if (signatureValue != null) {
            SignatureValueType sigVal = new SignatureValueType();
            sigVal.setValue(signatureValue);
            result.setSignatureValue(sigVal);
            result.setId(ReportUtil.createId());
        }
        result.setDocHashOnly(false);
        result.setHashOnly(false);
        return result;
    }

    protected ValidationStatusType createValidationStatus(boolean isMainResult) {
        ValidationStatusType result = etsiSvrObjectFactory.createValidationStatusType();
        CumulatedValidationResult overallResult = this.signatureValidationResult.getOverallResult(NestedResultCumulationInstruction.INCLUDE_VALIDATION_MESSAGES);
        MajorTotalResult majorTotalResult = overallResult.getMajor();
        String majorResult = isMainResult ? majorTotalResult.getTS119102ValidationReportUri() : majorTotalResult.getTS119102ValidationConstraintUri();
        if (majorTotalResult != MajorTotalResult.TOTAL_PASSED && overallResult.getMessages() != null && !overallResult.getMessages().isEmpty()) {
            this.addValidationMessages(result, overallResult);
        }
        result.setMainIndication(majorResult);
        for (MinorResult minor : overallResult.getMinorResults()) {
            if (minor.equals((Object)MinorResult.GENERIC)) {
                result.getSubIndication().add("urn:etsi:019102:subindication:CUSTOM");
                continue;
            }
            result.getSubIndication().add(minor.getTS119102Uri());
        }
        ValidationReportDataType validationReportData = this.createValidationReportData();
        if (validationReportData != null) {
            result.getAssociatedValidationReportData().add(validationReportData);
        }
        return result;
    }

    protected void addValidationMessages(ValidationStatusType result, CumulatedValidationResult overallResult) {
        ValidationMessageURIType validationMessageUris = svrExtensionObjectFactory.createValidationMessageURIType();
        List<String> messageUris = validationMessageUris.getURI();
        for (ValidationMessageCode code : overallResult.getMessages()) {
            messageUris.add("https://www.governikus.de/val-uri/validation-messages/" + code.getMessageCode());
        }
        TypedDataType messageUriType = new TypedDataType();
        messageUriType.setType("http://www.governikus.de/csl/svr/additionalTypes/ValidationMessageURIType");
        messageUriType.setValue((Object)validationMessageUris);
        AdditionalValidationReportDataType reportData = new AdditionalValidationReportDataType();
        reportData.getReportData().add(messageUriType);
        ValidationReportDataType messageData = new ValidationReportDataType();
        messageData.setAdditionalValidationReportData(reportData);
        result.getAssociatedValidationReportData().add(0, messageData);
    }

    protected ValidationReportDataType createValidationReportData() {
        return null;
    }

    protected CryptoInformationType createCryptoInformation() {
        CryptoInformationCreator creator = this.factory.createCryptoInformationCreator();
        CryptoInformationType result = creator.create((SignatureValidationResult)this.signatureValidationResult);
        return result;
    }

    protected CertificateChainType createCertificateChain() {
        PublicKeyCertificateValidationResult signingCertificateValidationResult = this.signatureValidationResult.getSigningCertificateValidationResult();
        if (signingCertificateValidationResult == null) {
            return null;
        }
        CertificateChainType chain = etsiSvrObjectFactory.createCertificateChainType();
        boolean first = true;
        while (signingCertificateValidationResult != null) {
            ValidationObjectType signingCertificateValidationObjectType = this.createSigningCertificateValidationObjectType(signingCertificateValidationResult);
            VOReferenceType ref = ReportUtil.createVOReference(signingCertificateValidationObjectType);
            if (first) {
                this.signingCertificateObjectType = signingCertificateValidationObjectType;
                first = false;
                chain.setSigningCertificate(ref);
                JAXBElement<String> validityModel = this.createValidityModel(signingCertificateValidationResult.getValidityModel());
                if (validityModel != null) {
                    chain.setAny(validityModel);
                }
            } else if (signingCertificateValidationResult.isTrustedAnchor()) {
                this.trustAnchor = signingCertificateValidationObjectType;
                chain.setTrustAnchor(ref);
            } else {
                chain.getIntermediateCertificate().add(ref);
            }
            signingCertificateValidationResult = signingCertificateValidationResult.getSigningCertificateValidationResult();
        }
        return chain;
    }

    private JAXBElement<String> createValidityModel(ValidityModelDeterminationResult validityModel) {
        if (validityModel != null && validityModel.getValidationMethod() != null) {
            switch (validityModel.getValidationMethod()) {
                case COMBINED: {
                    return svrExtensionObjectFactory.createValidityModel("https://www.governikus.de/val-uri/signature-validity-model/escape-route");
                }
                case FORK: {
                    return svrExtensionObjectFactory.createValidityModel("https://www.governikus.de/val-uri/signature-validity-model/chain");
                }
                case STRAIGHT: {
                    return svrExtensionObjectFactory.createValidityModel("https://www.governikus.de/val-uri/signature-validity-model/shell");
                }
            }
            return svrExtensionObjectFactory.createValidityModel("https://www.governikus.de/val-uri/signature-validity-model/unknown");
        }
        return null;
    }

    private ValidationObjectType createSigningCertificateValidationObjectType(PublicKeyCertificateValidationResult certResult) {
        CertificateValidationReportCreator childInstance = this.factory.createCertValidationReportCreator(certResult, this.validationDate, this.validationObjectConsumer, this.policy, this.reportContext);
        return childInstance.createSigningCertificateValidationObjectType();
    }

    protected ValidationConstraintsEvaluationReportType createValidationConstraintsEvaluationReport() {
        ValidationConstraintsEvaluationReportType result = etsiSvrObjectFactory.createValidationConstraintsEvaluationReportType();
        IndividualValidationConstraintReportCreator vcCreator = this.factory.createIndividualValidationConstraintReportCreator();
        List<IndividualValidationConstraintReportType> list = this.run(vcCreator);
        result.getValidationConstraint().addAll(list);
        return result;
    }

    protected ValidationTimeInfoType createValidationTimeInfo() {
        ValidationTimeInfoType result = null;
        if (this.signatureValidationResult.getBestSignatureTime() != null) {
            result = etsiSvrObjectFactory.createValidationTimeInfoType();
            POEType poeType = etsiSvrObjectFactory.createPOEType();
            poeType.setPOETime(ReportUtil.createXMLCalendar(this.signatureValidationResult.getBestSignatureTime()));
            poeType.setTypeOfProof("urn:etsi:019102:poetype:validation");
            result.setBestSignatureTime(poeType);
            result.setValidationTime(ReportUtil.createXMLCalendar(this.validationDate));
        }
        return result;
    }

    protected SignatureAttributesType createSignatureAttributes() {
        SignatureAttributesCreator attributeCreator = this.factory.createSignatureAttributeCreator(this.validationDate, this.validationObjectConsumer, this.policy, this.reportContext);
        return this.run(attributeCreator);
    }

    protected SignerInformationType createSignerInformation() {
        if (this.signingCertificateObjectType == null) {
            return null;
        }
        SignerInformationType result = etsiSvrObjectFactory.createSignerInformationType();
        result.setSignerCertificate(ReportUtil.createVOReference(this.signingCertificateObjectType));
        return result;
    }

    protected SignatureQualityType createSignatureQuality() {
        SignatureQualityCreator creator = this.factory.createSignatureQualityCreator();
        return this.run(creator);
    }

    protected SignatureValidationProcessType createSignatureValidationProcess() {
        SignatureValidationProcessType result = etsiSvrObjectFactory.createSignatureValidationProcessType();
        SignatureClass signatureClass = this.signatureValidationResult.getSignatureClass();
        if (signatureClass == SignatureClass.SIG_LT) {
            result.setSignatureValidationProcessID("urn:etsi:019102:validationprocess:LTVM");
        } else {
            result.setSignatureValidationProcessID("urn:etsi:019102:validationprocess:Basic");
        }
        return result;
    }

    protected <X> X run(SignatureValidationResultVisitor<X> visitor) {
        if (this.signatureValidationResult instanceof SignatureValidationResultExt) {
            return (X)((SignatureValidationResultExt)this.signatureValidationResult).process(visitor);
        }
        return (X)visitor.visit(this.signatureValidationResult);
    }

    protected VOReferenceType createTrustAnchor() {
        if (this.trustAnchor == null) {
            return null;
        }
        return ReportUtil.createVOReference(this.trustAnchor);
    }
}

