/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.sig_val_report;

import de.governikus.csl.sig_val_report.BaseSignatureValidationReportCreator;
import de.governikus.csl.sig_val_report.ReportCreationContext;
import de.governikus.csl.sig_val_report.ReportUtil;
import de.governikus.csl.sig_val_report.SigValReportFactory;
import de.governikus.csl.uom.validate.ValidatePolicy;
import de.governikus.csl.validate.svp.ArchiveTimestampValidationResult;
import java.util.Date;
import java.util.function.Consumer;
import org.etsi.uri._19102.v1_2_2.SignatureValidationReportType;
import org.etsi.uri._19102.v1_2_2.VOReferenceType;
import org.etsi.uri._19102.v1_2_2.ValidationObjectRepresentationType;
import org.etsi.uri._19102.v1_2_2.ValidationObjectType;
import org.etsi.uri._19102.v1_2_2.ValidationReportDataType;

public class ArchiveTimestampReportCreator
extends BaseSignatureValidationReportCreator<ArchiveTimestampValidationResult> {
    public ArchiveTimestampReportCreator(ArchiveTimestampValidationResult archiveTimestampValidationResult, Date validationDate, Consumer<ValidationObjectType> validationObjectConsumer, ValidatePolicy policy, ReportCreationContext reportContext) {
        super(archiveTimestampValidationResult, validationDate, validationObjectConsumer, policy, reportContext);
    }

    ArchiveTimestampReportCreator(ArchiveTimestampValidationResult archiveTimestampValidationResult, Date validationDate, Consumer<ValidationObjectType> validationObjectConsumer, ValidatePolicy policy, SigValReportFactory factory, ReportCreationContext reportContext) {
        super(archiveTimestampValidationResult, validationDate, validationObjectConsumer, policy, factory, reportContext);
    }

    public ValidationObjectType createArchiveTimestampValidationObject() {
        ValidationObjectType vot = etsiSvrObjectFactory.createValidationObjectType();
        String id = ReportUtil.createId();
        vot.setId(id);
        this.validationObjectConsumer.accept(vot);
        vot.setObjectType("urn:etsi:019102:validationObject:timestamp");
        ValidationObjectRepresentationType vor = etsiSvrObjectFactory.createValidationObjectRepresentationType();
        vot.setValidationObjectRepresentation(vor);
        vot.setValidationReport(this.createReport());
        ReportUtil.extendWithValidationObjectId(vot);
        String generationTime = ((ArchiveTimestampValidationResult)this.signatureValidationResult).getGenerationTime().toString();
        VOReferenceType archiveTstVoRef = ReportUtil.createVOReference(vot);
        this.reportContext.addTimeStampReference(generationTime, archiveTstVoRef);
        return vot;
    }

    private SignatureValidationReportType createReport() {
        SignatureValidationReportType result = etsiSvrObjectFactory.createSignatureValidationReportType();
        result.setSignatureValidationStatus(this.createValidationStatus(false));
        result.setValidationConstraintsEvaluationReport(this.createValidationConstraintsEvaluationReport());
        result.setValidationTimeInfo(this.createValidationTimeInfo());
        return result;
    }

    @Override
    protected ValidationReportDataType createValidationReportData() {
        ValidationReportDataType result = etsiSvrObjectFactory.createValidationReportDataType();
        result.setCryptoInformation(this.createCryptoInformation());
        result.setCertificateChain(this.createCertificateChain());
        return result;
    }
}

