/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.revocation.ocsp;

import de.governikus.csl.transport.HttpClient;
import de.governikus.csl.uom.jcebase.X509CertificateBaseFacade;
import de.governikus.csl.utils.CryptoProviderUtil;
import de.governikus.csl.validation.revocation.ocsp.OCSPRequestBuilderException;
import de.governikus.csl.validation.revocation.ocsp.OnlineOCSPRequester;
import de.governikus.csl.validation.revocation.service.TimedRevocationRequestResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.CertID;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartOCSPRequester
extends OnlineOCSPRequester {
    private static AlgorithmIdentifier algIdentifier = new DefaultDigestAlgorithmIdentifierFinder().find("SHA-1");
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartOCSPRequester.class);
    private Map<MyCertID, Future<TimedRevocationRequestResponse<OCSPResp>>> currentRequests = new ConcurrentHashMap<MyCertID, Future<TimedRevocationRequestResponse<OCSPResp>>>();

    public SmartOCSPRequester(HttpClient transportFactory, boolean sendNoCacheHeader) {
        super(transportFactory, sendNoCacheHeader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimedRevocationRequestResponse<OCSPResp> getOCSPResponse(X509CertificateBaseFacade<?> userCert, X509Certificate issuerCert, String url) throws IOException, OCSPRequestBuilderException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Requesting OCSP Values from {} for certificate from issuer {} with serial {}", new Object[]{url, userCert.getIssuerX500Principal(), userCert.getSerialNumber()});
        }
        MyCertID certID = this.buildCertID(userCert, issuerCert);
        certID.url = url;
        TimedRevocationRequestResponse<OCSPResp> resp = null;
        Future<TimedRevocationRequestResponse<OCSPResp>> future = this.currentRequests.get(certID);
        if (future != null) {
            LOGGER.debug("Parallel ocsp request detected");
            try {
                resp = future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Waiting for parallel ocsp response failed", e);
            }
            if (resp != null) {
                LOGGER.debug("Using result from parallel request. That save me {} ms", (Object)resp.getRequestDuration());
            }
        } else {
            CompletableFuture<TimedRevocationRequestResponse<OCSPResp>> f = new CompletableFuture<TimedRevocationRequestResponse<OCSPResp>>();
            this.currentRequests.put(certID, f);
            try {
                byte[] request = this.buildRequest(certID);
                resp = this.sendOCSPRequest(url, request);
                f.complete(resp);
            }
            catch (IOException e) {
                f.completeExceptionally(e);
                throw e;
            }
            catch (Exception e) {
                f.completeExceptionally(e);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Can't get ocsp response", (Throwable)e);
                } else {
                    LOGGER.info("Can't get ocsp response. Reason: {}", (Object)e.getMessage());
                }
            }
            finally {
                this.currentRequests.remove(certID);
                f.complete(resp);
            }
        }
        return resp;
    }

    private MyCertID buildCertID(X509CertificateBaseFacade<?> userCert, X509Certificate issuerCert) throws OCSPRequestBuilderException {
        try {
            BigInteger serialNumber = userCert.getSerialNumber();
            X509CertificateHolder certificateHolder = new X509CertificateHolder(issuerCert.getEncoded());
            JcaDigestCalculatorProviderBuilder jcaDigestCalculatorProviderbuilder = new JcaDigestCalculatorProviderBuilder();
            jcaDigestCalculatorProviderbuilder.setProvider(CryptoProviderUtil.PROVIDER);
            DigestCalculatorProvider digestCalculatorProvider = jcaDigestCalculatorProviderbuilder.build();
            DigestCalculator digCalc = digestCalculatorProvider.get(algIdentifier);
            MyCertID result = new MyCertID();
            OutputStream dgOut = digCalc.getOutputStream();
            dgOut.write(certificateHolder.toASN1Structure().getSubject().getEncoded("DER"));
            dgOut.close();
            MyCertID.access$202(result, digCalc.getDigest());
            SubjectPublicKeyInfo info = certificateHolder.getSubjectPublicKeyInfo();
            dgOut = digCalc.getOutputStream();
            dgOut.write(((ASN1BitString)((ASN1Sequence)info.toASN1Primitive()).getObjectAt(1)).getBytes());
            dgOut.close();
            MyCertID.access$302(result, digCalc.getDigest());
            result.serial = serialNumber;
            return result;
        }
        catch (IOException | CertificateEncodingException | OperatorCreationException e) {
            throw new OCSPRequestBuilderException(e);
        }
    }

    public byte[] buildRequest(MyCertID certID) throws OCSPRequestBuilderException {
        CertificateID id = new CertificateID(certID.toCertID());
        OCSPReqBuilder gen = new OCSPReqBuilder();
        gen.addRequest(id);
        try {
            OCSPReq req = gen.build();
            return req.getEncoded();
        }
        catch (IOException | OCSPException ex) {
            throw new OCSPRequestBuilderException(ex);
        }
    }

    private class MyCertID {
        private String url;
        private byte[] issuerNameHash;
        private byte[] issuerKeyHash;
        private BigInteger serial;

        private MyCertID() {
        }

        private CertID toCertID() {
            DEROctetString issuerNameHash = new DEROctetString(this.issuerNameHash);
            DEROctetString issuerKeyHash = new DEROctetString(this.issuerKeyHash);
            ASN1Integer serialNumber = new ASN1Integer(this.serial);
            return new CertID(algIdentifier, (ASN1OctetString)issuerNameHash, (ASN1OctetString)issuerKeyHash, serialNumber);
        }

        public int hashCode() {
            int hash = 1;
            hash = hash * 17 + this.serial.hashCode();
            hash = hash * 43 + this.url.hashCode();
            hash = hash * 13 + Arrays.hashCode(this.issuerNameHash);
            hash = hash * 31 + Arrays.hashCode(this.issuerKeyHash);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MyCertID) {
                MyCertID other = (MyCertID)obj;
                return other.serial.equals(this.serial) && other.url.equals(this.url) && Arrays.equals(other.issuerKeyHash, this.issuerKeyHash) && Arrays.equals(this.issuerNameHash, other.issuerNameHash);
            }
            return false;
        }

        static /* synthetic */ byte[] access$202(MyCertID x0, byte[] x1) {
            x0.issuerNameHash = x1;
            return x1;
        }

        static /* synthetic */ byte[] access$302(MyCertID x0, byte[] x1) {
            x0.issuerKeyHash = x1;
            return x1;
        }
    }
}

