/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.revocation.ocsp;

import de.governikus.csl.transport.HttpClient;
import de.governikus.csl.transport.HttpHeader;
import de.governikus.csl.transport.HttpRequest;
import de.governikus.csl.transport.HttpResponse;
import de.governikus.csl.transport.entity.ByteArrayRequest;
import de.governikus.csl.transport.exception.ResponseException;
import de.governikus.csl.uom.jcebase.X509CertificateBaseFacade;
import de.governikus.csl.utils.CryptoProviderUtil;
import de.governikus.csl.utils.MinimalTimeReentrantLock;
import de.governikus.csl.validation.revocation.ocsp.OCSPRequestBuilderException;
import de.governikus.csl.validation.revocation.ocsp.OCSPRequester;
import de.governikus.csl.validation.revocation.service.TimedRevocationRequestResponse;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URI;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineOCSPRequester
implements OCSPRequester {
    private static final Logger OCSP_RESPONSE_LOGGER = LoggerFactory.getLogger((String)"CVS_OCSP_RESPONSE_LOG");
    private static final Logger LOGGER = LoggerFactory.getLogger(OnlineOCSPRequester.class);
    private MinimalTimeReentrantLock bNetzLock = new MinimalTimeReentrantLock(1100L);
    private HttpClient client;
    private HttpHeader[] headers;

    public OnlineOCSPRequester(HttpClient httpClient, boolean sendNoCacheHeader) {
        this.client = httpClient;
        int pos = 0;
        if (sendNoCacheHeader) {
            this.headers = new HttpHeader[8];
            this.headers[pos++] = new HttpHeader("Cache-Control", "no-cache");
            this.headers[pos++] = new HttpHeader("max-age", "0");
            this.headers[pos++] = new HttpHeader("post-check", "0");
            this.headers[pos++] = new HttpHeader("precheck", "0");
            this.headers[pos++] = new HttpHeader("must-revalidate", "");
            this.headers[pos++] = new HttpHeader("Pragma", "no-cache");
        } else {
            this.headers = new HttpHeader[2];
        }
        this.headers[pos++] = new HttpHeader("Accept", "application/ocsp-response");
        this.headers[pos++] = new HttpHeader("Content-Type", "application/ocsp-request");
    }

    @Override
    public TimedRevocationRequestResponse<OCSPResp> getOCSPResponse(X509CertificateBaseFacade<?> userCert, X509Certificate issuerCert, String url) throws IOException, OCSPRequestBuilderException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Requesting OCSP values from {} for certificate {}", (Object)url, (Object)userCert.getSerialNumber());
        }
        byte[] request = this.buildRequest(userCert, issuerCert);
        return this.sendOCSPRequest(url, request);
    }

    public byte[] buildRequest(X509CertificateBaseFacade<?> userCert, X509Certificate issuerCert) throws OCSPRequestBuilderException {
        try {
            BigInteger serialNumber = userCert.getSerialNumber();
            X509CertificateHolder certificateHolder = new X509CertificateHolder(issuerCert.getEncoded());
            AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find("SHA1withRSA");
            JcaDigestCalculatorProviderBuilder jcaDigestCalculatorProviderbuilder = new JcaDigestCalculatorProviderBuilder();
            jcaDigestCalculatorProviderbuilder.setProvider(CryptoProviderUtil.PROVIDER);
            DigestCalculatorProvider digestCalculatorProvider = jcaDigestCalculatorProviderbuilder.build();
            DigestCalculator digestCalculator = digestCalculatorProvider.get(new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId));
            CertificateID id = new CertificateID(digestCalculator, certificateHolder, serialNumber);
            OCSPReqBuilder gen = new OCSPReqBuilder();
            gen.addRequest(id);
            OCSPReq req = gen.build();
            return req.getEncoded();
        }
        catch (IOException | CertificateEncodingException | OCSPException | OperatorCreationException e) {
            throw new OCSPRequestBuilderException(e);
        }
    }

    protected TimedRevocationRequestResponse<OCSPResp> sendOCSPRequest(String url, byte[] ocspReq) throws IOException {
        MinimalTimeReentrantLock lock = null;
        if ("http://ocsp.nrca-ds.de:8080/ocsp-ocspresponder".equals(url)) {
            lock = this.bNetzLock;
            lock.lock();
        }
        long time = System.currentTimeMillis();
        try {
            byte[] bytes = this.sendHTTPRequest(url, ocspReq);
            long duration = System.currentTimeMillis() - time;
            if (bytes == null) {
                OCSP_RESPONSE_LOGGER.info("{};{};EmptyResponse;", (Object)url, (Object)duration);
                TimedRevocationRequestResponse<OCSPResp> timedRevocationRequestResponse = null;
                return timedRevocationRequestResponse;
            }
            OCSP_RESPONSE_LOGGER.info("{};{};;", (Object)url, (Object)duration);
            OCSPResp ocspResp = new OCSPResp(bytes);
            TimedRevocationRequestResponse<OCSPResp> timedRevocationRequestResponse = new TimedRevocationRequestResponse<OCSPResp>(ocspResp, duration);
            return timedRevocationRequestResponse;
        }
        catch (IllegalStateException e) {
            OCSP_RESPONSE_LOGGER.info("{};{};{};", new Object[]{url, System.currentTimeMillis() - time, e.getMessage()});
            throw new CertIOException("malformed response: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            OCSP_RESPONSE_LOGGER.info("{};{};{};", new Object[]{url, System.currentTimeMillis() - time, e.getMessage()});
            throw e;
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] sendHTTPRequest(String url, byte[] request) throws IOException {
        HttpResponse resp = null;
        try {
            resp = this.client.post(URI.create(url), (HttpRequest)new ByteArrayRequest(request), this.headers);
            int status = resp.getStatus();
            if (status >= 300) {
                throw new ResponseException(url, status, resp.getStatusReason());
            }
            byte[] byArray = this.readResponse(resp);
            return byArray;
        }
        finally {
            if (resp != null) {
                try {
                    resp.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Can't close http response", (Throwable)e);
                }
            }
        }
    }

    private byte[] readResponse(HttpResponse resp) throws IOException {
        try (InputStream is = resp.getContent();){
            byte[] byArray = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
    }
}

