/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.revocation.ocsp;

import de.governikus.csl.core.impl.RevocationValue;
import de.governikus.csl.transport.exception.ConnectionException;
import de.governikus.csl.transport.exception.ResponseException;
import de.governikus.csl.uom.jcebase.X509CertificateBaseFacade;
import de.governikus.csl.validation.revocation.ocsp.OCSPRequestBuilderException;
import de.governikus.csl.validation.revocation.service.TimedRevocationRequestResponse;
import java.io.IOException;
import java.security.cert.X509Certificate;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.cert.ocsp.OCSPResp;

public interface OCSPRequester {
    public TimedRevocationRequestResponse<OCSPResp> getOCSPResponse(X509CertificateBaseFacade<?> var1, X509Certificate var2, String var3) throws IOException, OCSPRequestBuilderException;

    default public RevocationValue revocationValueFromException(Exception exception) {
        Throwable t;
        if (exception instanceof ResponseException) {
            ResponseException responseException = (ResponseException)exception;
            RevocationValue revocationValue = new RevocationValue();
            revocationValue.addValidationMessage("revocation_values_not_found_response_error", new Object[]{responseException.getSource(), responseException.getStatus()});
            return revocationValue;
        }
        if (exception instanceof ConnectionException) {
            ConnectionException connectionException = (ConnectionException)exception;
            RevocationValue revocationValue = new RevocationValue();
            revocationValue.addValidationMessage("revocation_values_not_found_connection_error", new Object[]{connectionException.getUri()});
            return revocationValue;
        }
        for (t = exception; t.getCause() != null && t.getCause() != t; t = t.getCause()) {
        }
        String message = t.getMessage();
        if (message == null) {
            message = t.getClass().getName();
        }
        RevocationValue revocationValue = new RevocationValue();
        revocationValue.addValidationMessage("revocation_values_not_found_general_error", new Object[]{StringUtils.abbreviate((String)message, (int)80)});
        return revocationValue;
    }
}

