/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.validation.revocation.ocsp;

import de.governikus.csl.uom.jcebase.X509CertificateBaseFacade;
import de.governikus.csl.validation.circuitbreaker.CircuitBreaker;
import de.governikus.csl.validation.circuitbreaker.CircuitBreakerManager;
import de.governikus.csl.validation.circuitbreaker.CircuitBreakerOptions;
import de.governikus.csl.validation.revocation.ocsp.OCSPRequestBuilderException;
import de.governikus.csl.validation.revocation.ocsp.OCSPRequester;
import de.governikus.csl.validation.revocation.service.TimedRevocationRequestResponse;
import java.io.IOException;
import java.security.cert.X509Certificate;
import org.bouncycastle.cert.ocsp.OCSPResp;

public class FailFastOCSPRequester
implements OCSPRequester {
    private OCSPRequester delegate;
    private CircuitBreakerManager manager;

    public FailFastOCSPRequester(OCSPRequester delegate, CircuitBreakerOptions options) {
        this.delegate = delegate;
        this.manager = new CircuitBreakerManager(options);
    }

    public FailFastOCSPRequester(OCSPRequester delegate, CircuitBreakerManager manager) {
        this.delegate = delegate;
        this.manager = manager;
    }

    @Override
    public TimedRevocationRequestResponse<OCSPResp> getOCSPResponse(X509CertificateBaseFacade<?> userCert, X509Certificate issuerCert, String url) throws IOException, OCSPRequestBuilderException {
        CircuitBreaker circuitBreaker = this.manager.get(url);
        circuitBreaker.check();
        try {
            TimedRevocationRequestResponse<OCSPResp> response = this.delegate.getOCSPResponse(userCert, issuerCert, url);
            circuitBreaker.reportSuccess();
            return response;
        }
        catch (IOException e) {
            circuitBreaker.reportFailure();
            throw e;
        }
    }
}

