/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csc.authentication.keycloak.client;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.authorization.client.ClientAuthenticator;
import org.keycloak.authorization.client.Configuration;
import org.keycloak.crypto.AsymmetricSignatureSignerContext;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.util.JsonSerialization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeycloakAuthClient {
    private static final Logger LOG = LoggerFactory.getLogger(KeycloakAuthClient.class);
    private JsonWebToken jwt;
    private String accessToken;
    private String tokenType;
    private AuthzClient authzClient;
    private KeycloakDeployment keycloakDeployment;
    private String username;
    private String password;
    private boolean resourceOwnerPassword = false;

    public KeycloakAuthClient(KeycloakDeployment keycloakDeployment) {
        this.keycloakDeployment = keycloakDeployment;
        if (keycloakDeployment != null && keycloakDeployment.getResourceCredentials().containsKey("jwt")) {
            this.authzClient = AuthzClient.create((Configuration)new Configuration(keycloakDeployment.getAuthServerBaseUrl(), keycloakDeployment.getRealm(), keycloakDeployment.getResourceName(), keycloakDeployment.getResourceCredentials(), keycloakDeployment.getClient()), (ClientAuthenticator)this.getJwtClientAuthenticator());
        } else if (keycloakDeployment != null && keycloakDeployment.getResourceCredentials().containsKey("secret")) {
            this.authzClient = AuthzClient.create((Configuration)new Configuration(keycloakDeployment.getAuthServerBaseUrl(), keycloakDeployment.getRealm(), keycloakDeployment.getResourceName(), keycloakDeployment.getResourceCredentials(), keycloakDeployment.getClient()));
        } else {
            throw new IllegalArgumentException("Resource Credentials missing !");
        }
    }

    public KeycloakAuthClient(KeycloakDeployment keycloakDeployment, String username, String password) {
        this.keycloakDeployment = keycloakDeployment;
        this.username = username;
        this.password = password;
        this.resourceOwnerPassword = true;
        if (username == null || password == null || username.isEmpty() || password.isEmpty()) {
            throw new IllegalArgumentException("username and password missing !");
        }
        if (keycloakDeployment == null || !keycloakDeployment.getResourceCredentials().containsKey("secret")) {
            throw new IllegalArgumentException("Only Resource Credentials Secret is allowed !");
        }
        this.authzClient = AuthzClient.create((Configuration)new Configuration(keycloakDeployment.getAuthServerBaseUrl(), keycloakDeployment.getRealm(), keycloakDeployment.getResourceName(), keycloakDeployment.getResourceCredentials(), keycloakDeployment.getClient()));
    }

    public String getBearerTokenHeader() throws IOException, JWSInputException {
        this.retrieveToken();
        String token = this.accessToken;
        return this.tokenType + " " + token;
    }

    public synchronized void retrieveToken() throws IOException, JWSInputException {
        if (this.accessToken == null || this.jwt == null || this.jwt.isExpired()) {
            LOG.debug("Fetching new access token from the authorization server");
            AccessTokenResponse response = this.obtainAccessToken();
            this.accessToken = response.getToken();
            this.tokenType = response.getTokenType();
            JWSInput jwsInput = new JWSInput(this.accessToken);
            this.jwt = (JsonWebToken)JsonSerialization.readValue((byte[])jwsInput.getContent(), JsonWebToken.class);
            LOG.debug("Got new access token (expires at: {})", (Object)Instant.ofEpochSecond(this.jwt.getExp()).toString());
        }
    }

    private AccessTokenResponse obtainAccessToken() {
        if (!this.resourceOwnerPassword) {
            return this.authzClient.obtainAccessToken();
        }
        return this.authzClient.obtainAccessToken(this.username, this.password);
    }

    public String getAccessToken() throws IOException, JWSInputException {
        this.retrieveToken();
        return this.accessToken;
    }

    private ClientAuthenticator getJwtClientAuthenticator() {
        return (requestParams, requestHeaders) -> {
            String signedRequestToken = this.getSignedRequestToken();
            requestParams.put("client_assertion_type", Collections.singletonList("urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
            requestParams.put("client_assertion", Collections.singletonList(signedRequestToken));
        };
    }

    private String getSignedRequestToken() {
        try {
            PrivateKey signatureKey = this.loadSignatureKey();
            KeyWrapper keyWrapper = new KeyWrapper();
            keyWrapper.setPrivateKey((Key)signatureKey);
            keyWrapper.setAlgorithm(this.getAlgorithm());
            return new JWSBuilder().jsonContent((Object)this.getJwt()).sign((SignatureSignerContext)new AsymmetricSignatureSignerContext(keyWrapper));
        }
        catch (IOException | GeneralSecurityException e) {
            LOG.error("Could not sign JSON web token", (Throwable)e);
            return null;
        }
    }

    private JsonWebToken getJwt() {
        String audience = String.format("%s/realms/%s", this.keycloakDeployment.getAuthServerBaseUrl(), this.keycloakDeployment.getRealm());
        return new JsonWebToken().id(UUID.randomUUID().toString()).issuer(this.keycloakDeployment.getResourceName()).subject(this.keycloakDeployment.getResourceName()).audience(new String[]{audience}).issuedNow();
    }

    private Map<String, String> getJWTMap() {
        return (Map)this.keycloakDeployment.getResourceCredentials().get("jwt");
    }

    private String getAlgorithm() {
        String algorithm;
        Map<String, String> jwtMap = this.getJWTMap();
        String algoDeploy = "";
        if (jwtMap != null && jwtMap.get("algorithm") != null) {
            algoDeploy = jwtMap.get("algorithm");
        }
        switch (algoDeploy) {
            case "ES256": {
                algorithm = "ES256";
                break;
            }
            case "ES384": {
                algorithm = "ES384";
                break;
            }
            case "ES512": {
                algorithm = "ES512";
                break;
            }
            case "HS256": {
                algorithm = "HS256";
                break;
            }
            case "HS384": {
                algorithm = "HS384";
                break;
            }
            case "HS512": {
                algorithm = "HS512";
                break;
            }
            case "PS256": {
                algorithm = "PS256";
                break;
            }
            case "PS384": {
                algorithm = "PS384";
                break;
            }
            case "PS512": {
                algorithm = "PS512";
                break;
            }
            case "RS256": {
                algorithm = "RS256";
                break;
            }
            case "RS384": {
                algorithm = "RS384";
                break;
            }
            case "RS512": {
                algorithm = "RS512";
                break;
            }
            default: {
                algorithm = "RS256";
            }
        }
        return algorithm;
    }

    private PrivateKey loadSignatureKey() throws GeneralSecurityException, IOException {
        Map<String, String> jwtMap = this.getJWTMap();
        String keystorePath = jwtMap.get("client-keystore-file");
        String keystorePassword = jwtMap.get("client-keystore-password");
        String alias = jwtMap.get("client-key-alias");
        String keystoreType = jwtMap.get("client-keystore-type");
        if (alias == null || alias.isEmpty()) {
            alias = this.keycloakDeployment.getResourceName();
        }
        if (keystoreType == null || keystoreType.isEmpty()) {
            keystoreType = "JKS";
        }
        KeyStore keyStore = KeyStore.getInstance(keystoreType);
        boolean isClasspath = keystorePath.startsWith("classpath:");
        if (isClasspath) {
            try (InputStream is = KeycloakAuthClient.class.getClassLoader().getResourceAsStream(keystorePath.replaceFirst("^classpath:", ""));){
                keyStore.load(is, keystorePassword.toCharArray());
            }
        }
        try (FileInputStream inputStream = new FileInputStream(keystorePath);){
            keyStore.load(inputStream, keystorePassword.toCharArray());
        }
        return (PrivateKey)keyStore.getKey(alias, keystorePassword.toCharArray());
    }
}

