/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.filemanager.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.BasicPolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.type.TypeFactory;
import de.governikus.csc.health.HealthCheckCaller;
import de.governikus.csc.health.HealthCheckClient;
import de.governikus.csc.health.HealthSummary;
import de.governikus.csc.health.PingClient;
import de.governikus.csc.health.PingResponseHandler;
import de.governikus.csc.keycloak.client.AccessTokenClient;
import de.governikus.csl.filemanager.CategoryNotFoundException;
import de.governikus.csl.filemanager.ExceptionMapper;
import de.governikus.csl.filemanager.FileHandler;
import de.governikus.csl.filemanager.FilemanagerException;
import de.governikus.csl.filemanager.FilemanagerExceptionReason;
import de.governikus.csl.filemanager.ResourceNotFoundException;
import de.governikus.csl.filemanager.client.FileManagerClient;
import de.governikus.csl.filemanager.client.FileManagerClientOIDCBuilder;
import de.governikus.csl.filemanager.fileinfo.FileInfo;
import de.governikus.csl.filemanager.fileinfo.FolderInfo;
import de.governikus.csl.transport.HttpClient;
import de.governikus.csl.transport.HttpHeader;
import de.governikus.csl.transport.HttpRequest;
import de.governikus.csl.transport.HttpResponse;
import de.governikus.csl.transport.HttpResponseHandler;
import de.governikus.csl.transport.entity.ByteArrayRequest;
import de.governikus.csl.transport.entity.InputStreamRequest;
import de.governikus.csl.transport.exception.ResponseException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.HttpResponseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilemanagerClientOIDC
implements FileManagerClient,
HealthCheckClient,
PingClient {
    private static final Logger log = LoggerFactory.getLogger(FilemanagerClientOIDC.class);
    static final String SYNC_ID = "syncId";
    private static final String SAVE_FILE = "/saveFile/";
    private static final String DEFAULT = "/default/";
    private static final String RESOURCES = "/resources/";
    private static final String DELETE = "/deleteFile/";
    private static final String CHECK_TOKEN = "/checkToken";
    private static final String SYNCHRONIZE = "/synchronize";
    private static final TypeFactory FILE_INFO = TypeFactory.defaultInstance().withClassLoader(FileInfo.class.getClassLoader());
    private static final TypeFactory FOLDER_INFO = TypeFactory.defaultInstance().withClassLoader(FolderInfo.class.getClassLoader());
    private static final HttpHeader APPLICATION_JSON = new HttpHeader("Accept", "application/json");
    private final HttpClient httpClient;
    private final String baseURI;
    private final AccessTokenClient keycloakClient;
    private final ObjectMapper objectMapper;

    public FilemanagerClientOIDC(String baseURI, HttpClient httpClient, AccessTokenClient keycloakClient) {
        this.baseURI = baseURI;
        this.httpClient = httpClient;
        this.keycloakClient = keycloakClient;
        BasicPolymorphicTypeValidator validator = BasicPolymorphicTypeValidator.builder().allowIfBaseType(FolderInfo.class).allowIfBaseType(FileInfo.class).allowIfBaseType("de.governikus.csl.filemanager.fileinfo.").build();
        this.objectMapper = new ObjectMapper().setPolymorphicTypeValidator((PolymorphicTypeValidator)validator);
    }

    public String startSynchronize() throws FilemanagerException {
        String fmId = null;
        URI uri = URI.create(this.baseURI + SYNCHRONIZE);
        try {
            log.debug("Start synchronizing local filemanager");
            String bearerTokenHeader = this.keycloakClient.getBearerTokenHeader();
            HttpHeader header = new HttpHeader("Authorization", bearerTokenHeader);
            try (HttpResponse httpResponse = this.httpClient.get(uri, new HttpHeader[]{header});){
                if (httpResponse.getStatus() == 404) {
                    throw new FilemanagerException(FilemanagerExceptionReason.UNKNOWN_OPERATION, "Operation GET not supported for '" + uri.toString() + "'!");
                }
                this.checkResponseStatus(null, null, httpResponse);
                fmId = this.getValueFromHeader(httpResponse, SYNC_ID, null);
            }
        }
        catch (IOException e) {
            throw this.mapException(e, null, null);
        }
        return fmId;
    }

    public void endSynchronize(String syncId, String msgText) throws FilemanagerException {
        URI uri = URI.create(this.baseURI + SYNCHRONIZE);
        try {
            log.debug("End synchronizing local filemanager");
            String bearerTokenHeader = this.keycloakClient.getBearerTokenHeader();
            HttpHeader authHeader = new HttpHeader("Authorization", bearerTokenHeader);
            HttpHeader syncHeader = new HttpHeader(SYNC_ID, syncId);
            ByteArrayRequest request = null;
            if (msgText != null && !msgText.isEmpty()) {
                log.debug("Create a request with error message: {}", (Object)msgText);
                request = new ByteArrayRequest(msgText.getBytes(), "text/plain", StandardCharsets.UTF_8.name());
            }
            try (HttpResponse httpResponse = this.httpClient.post(uri, request, new HttpHeader[]{authHeader, syncHeader});){
                if (httpResponse.getStatus() == 404) {
                    throw new FilemanagerException(FilemanagerExceptionReason.UNKNOWN_OPERATION, "Operation POST not supported for '" + uri.toString() + "'!");
                }
                this.checkResponseStatus(null, null, httpResponse);
            }
        }
        catch (IOException e) {
            throw this.mapException(e, null, null);
        }
    }

    private String getValueFromHeader(HttpResponse httpResponse, String headerName, String defaultValue) {
        return httpResponse.getHeader().stream().filter(x -> x.getName().equals(headerName)).map(HttpHeader::getValue).findFirst().orElse(defaultValue);
    }

    @Override
    public void addFile(String category, InputStream is) throws FilemanagerException {
        URI uri = URI.create(this.baseURI + SAVE_FILE + category);
        try {
            log.debug("Adding new file for category {}", (Object)category);
            String bearerTokenHeader = this.keycloakClient.getBearerTokenHeader();
            HttpHeader header = new HttpHeader("Authorization", bearerTokenHeader);
            InputStreamRequest request = new InputStreamRequest(is, "application/octet-stream", null);
            try (HttpResponse httpResponse = this.httpClient.put(uri, (HttpRequest)request, new HttpHeader[]{header});){
                this.checkResponseStatus(category, null, httpResponse);
            }
            log.info("Added new file for category {}", (Object)category);
        }
        catch (IOException e) {
            throw this.mapException(e, category, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> getList(String category) throws FilemanagerException {
        URI uri = URI.create(this.baseURI + RESOURCES + category);
        try (HttpResponse httpResponse = this.httpClient.get(uri, new HttpHeader[]{APPLICATION_JSON});){
            this.checkResponseStatus(category, null, httpResponse);
            FolderInfo folderInfo = this.getContent(httpResponse, FolderInfo.class);
            if (folderInfo == null) {
                List<String> list = Collections.emptyList();
                return list;
            }
            List<String> list = folderInfo.getContents().stream().map(FileInfo::getName).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw this.mapException(e, category, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getDefault(String category) throws FilemanagerException {
        URI uri = URI.create(this.baseURI + DEFAULT + category);
        try (HttpResponse httpResponse = this.httpClient.get(uri, new HttpHeader[]{APPLICATION_JSON});){
            this.checkResponseStatus(category, null, httpResponse);
            FileInfo fileInfo = this.getContent(httpResponse, FileInfo.class);
            String string = fileInfo.getName();
            return string;
        }
        catch (IOException e) {
            throw this.mapException(e, category, null);
        }
    }

    public boolean checkToken() throws FilemanagerException {
        try {
            URI uri = URI.create(this.baseURI + CHECK_TOKEN);
            String bearerToken = this.keycloakClient.getBearerTokenHeader();
            HttpHeader bearerTokenHeader = new HttpHeader("Authorization", bearerToken);
            int httpCode = -1;
            try (HttpResponse httpResponse = this.httpClient.get(uri, new HttpHeader[]{bearerTokenHeader});){
                httpCode = httpResponse.getStatus();
            }
            switch (httpCode) {
                case 200: {
                    return true;
                }
                case 401: {
                    return false;
                }
            }
            throw new FilemanagerException(FilemanagerExceptionReason.SERVER_ERROR, "Server returned HTTP code: " + httpCode);
        }
        catch (IOException e) {
            throw this.mapException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileInfo getMetadata(String category, String id) throws FilemanagerException {
        URI uri = URI.create(this.baseURI + RESOURCES + category + "/" + id + "/metadata");
        try (HttpResponse httpResponse = this.httpClient.get(uri, new HttpHeader[]{APPLICATION_JSON});){
            this.checkResponseStatus(category, id, httpResponse);
            FileInfo fileInfo = this.getContent(httpResponse, FileInfo.class);
            return fileInfo;
        }
        catch (IOException e) {
            throw this.mapException(e, category, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream getFile(String category, String id) throws FilemanagerException {
        URI uri = URI.create(this.baseURI + RESOURCES + category + "/" + id);
        try (HttpResponse httpResponse = this.httpClient.get(uri, new HttpHeader[0]);){
            this.checkResponseStatus(category, id, httpResponse);
            byte[] byteArray = IOUtils.toByteArray((InputStream)httpResponse.getContent());
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray);
            return byteArrayInputStream;
        }
        catch (IOException e) {
            throw this.mapException(e, category, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T getFile(String category, String id, FileHandler<T> filehandler) throws FilemanagerException {
        URI uri = URI.create(this.baseURI + RESOURCES + category + "/" + id);
        try (HttpResponse httpResponse = this.httpClient.get(uri, new HttpHeader[0]);){
            this.checkResponseStatus(category, id, httpResponse);
            T t = filehandler.handleFile(httpResponse.getContent());
            return t;
        }
        catch (IOException e) {
            throw this.mapException(e, category, null);
        }
    }

    @Override
    public void deleteFile(String category, String id) throws FilemanagerException {
        URI uri = URI.create(this.baseURI + DELETE + category + "/" + id);
        try {
            String bearerTokenHeader = this.keycloakClient.getBearerTokenHeader();
            HttpHeader header = new HttpHeader("Authorization", bearerTokenHeader);
            try (HttpResponse httpResponse = this.httpClient.delete(uri, new HttpHeader[]{header});){
                this.checkResponseStatus(category, id, httpResponse);
            }
        }
        catch (IOException e) {
            throw this.mapException(e);
        }
    }

    @Override
    public String getFileURLBase() {
        return this.baseURI + RESOURCES;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getFileExternalURLBase() {
        URI uri = URI.create(this.baseURI + "/externalURL");
        try (HttpResponse httpResponse = this.httpClient.get(uri, new HttpHeader[0]);){
            String string = IOUtils.toString((InputStream)httpResponse.getContent(), (Charset)StandardCharsets.UTF_8) + "/resources";
            return string;
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    public HealthSummary checkHealth() throws IOException {
        return HealthCheckCaller.checkHealth((HttpClient)this.httpClient, (String)(this.baseURI + "/health"));
    }

    public void pingService() throws IOException {
        this.httpClient.get(URI.create(this.baseURI + "/health/ping"), (HttpResponseHandler)new PingResponseHandler(), new HttpHeader[0]);
    }

    public void close() throws IOException {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T getContent(HttpResponse response, Class<T> clazz) throws FilemanagerException {
        if (clazz.equals(FolderInfo.class)) {
            this.objectMapper.setTypeFactory(FOLDER_INFO);
        } else if (clazz.equals(FileInfo.class)) {
            this.objectMapper.setTypeFactory(FILE_INFO);
        }
        try (InputStream is = response.getContent();){
            Object object = this.objectMapper.readValue(is, clazz);
            return (T)object;
        }
        catch (IOException e) {
            throw new FilemanagerException(FilemanagerExceptionReason.INTERNAL_ERROR, e);
        }
    }

    private void checkResponseStatus(String category, String id, HttpResponse httpResponse) throws FilemanagerException {
        if (httpResponse.getStatus() == 400) {
            throw new FilemanagerException(FilemanagerExceptionReason.BAD_INPUT, httpResponse.getStatusReason());
        }
        if (httpResponse.getStatus() == 404) {
            if (id == null) {
                throw new CategoryNotFoundException(category);
            }
            throw new ResourceNotFoundException(category, id);
        }
        if (httpResponse.getStatus() >= 300) {
            throw new FilemanagerException(FilemanagerExceptionReason.SERVER_ERROR, httpResponse.getStatusReason());
        }
    }

    private FilemanagerException mapException(Exception e) {
        return this.mapException(e, null, null);
    }

    private FilemanagerException mapException(Exception e, String category, String resource) {
        if (e instanceof FilemanagerException) {
            return (FilemanagerException)e;
        }
        if (e instanceof HttpResponseException) {
            return new FilemanagerException(FilemanagerExceptionReason.AUTHENTICATION_ERROR, e);
        }
        if (e instanceof ResponseException) {
            return ExceptionMapper.mapResponseException((ResponseException)e, category, resource);
        }
        if (e instanceof IOException) {
            return ExceptionMapper.mapIOException((IOException)e);
        }
        return new FilemanagerException(FilemanagerExceptionReason.SERVER_ERROR, e);
    }

    @NonNull
    public static FileManagerClientOIDCBuilder builder() {
        return new FileManagerClientOIDCBuilder();
    }
}

