/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.filemanager.client;

import de.governikus.csc.keycloak.client.AccessTokenClient;
import de.governikus.csc.keycloak.client.OAuthClient;
import de.governikus.csl.filemanager.client.AbstractFileManagerClientBuilder;
import de.governikus.csl.filemanager.client.FileManagerClient;
import de.governikus.csl.filemanager.client.FilemanagerClientOIDC;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import lombok.NonNull;

public class FileManagerClientOIDCBuilder
extends AbstractFileManagerClientBuilder<FileManagerClientOIDCBuilder> {
    private AccessTokenClient client;
    private String jsonConfigFile;

    @NonNull
    public FileManagerClientOIDCBuilder keycloakClient(@NonNull AccessTokenClient client) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        this.client = client;
        return this;
    }

    @NonNull
    public FileManagerClientOIDCBuilder jsonConfig(@NonNull String jsonConfig) {
        if (jsonConfig == null) {
            throw new NullPointerException("jsonConfig is marked non-null but is null");
        }
        this.jsonConfigFile = jsonConfig;
        return this;
    }

    @Override
    @NonNull
    public FileManagerClient build() throws URISyntaxException, CertificateException, IOException, NoSuchProviderException {
        if (this.client == null && this.jsonConfigFile == null) {
            throw new IllegalArgumentException("Either KeycloakClient or KeycloakClient Configuration must not be null.");
        }
        return new FilemanagerClientOIDC(this.getOrCreateUri().getPath(), this.getOrCreateHttpClient(), this.getOrCreateKeyCloakClient());
    }

    @NonNull
    private AccessTokenClient getOrCreateKeyCloakClient() throws IOException {
        if (this.client == null) {
            this.client = new OAuthClient(this.jsonConfigFile);
        }
        return this.client;
    }
}

