/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.filemanager.client;

import de.governikus.csl.filemanager.CategoryNotFoundException;
import de.governikus.csl.filemanager.FileHandler;
import de.governikus.csl.filemanager.FilemanagerException;
import de.governikus.csl.filemanager.FilemanagerExceptionReason;
import de.governikus.csl.filemanager.client.FileManagerClient;
import de.governikus.csl.filemanager.fileinfo.FileInfo;
import de.governikus.csl.uom.LogHelper;
import de.governikus.csl.utils.CryptoProviderUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileManagerClientImplTransient
implements FileManagerClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileManagerClientImplTransient.class);
    private Map<String, DataSet> data;
    private MessageDigest digest;
    private String digestAlgorithm;

    public FileManagerClientImplTransient() {
        this("SHA1");
    }

    public FileManagerClientImplTransient(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
        this.data = new HashMap<String, DataSet>();
        try {
            this.digest = CryptoProviderUtil.getMessageDigestInstance((String)digestAlgorithm);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            LogHelper.logException((String)"Can't get message digest instance", (Logger)LOGGER, (Throwable)e);
        }
    }

    @Override
    public void addFile(String category, InputStream is) throws FilemanagerException {
        try {
            this.addFile(category, IOUtils.toByteArray((InputStream)is));
        }
        catch (IOException e) {
            throw new FilemanagerException(FilemanagerExceptionReason.INTERNAL_ERROR, e);
        }
    }

    public void addFile(String category, byte[] data) {
        byte[] hash = this.digest.digest(data);
        String base64String = Base64.getEncoder().encodeToString(hash);
        DataSet ds = new DataSet();
        ds.b64Hash = this.digestAlgorithm + "_" + base64String;
        ds.data = data;
        this.data.put(category, ds);
    }

    @Override
    public List<String> getList(String category) throws FilemanagerException {
        DataSet dataSet = this.data.get(category);
        if (dataSet != null) {
            Collections.singletonList(dataSet.b64Hash);
        }
        return Collections.emptyList();
    }

    @Override
    public String getDefault(String category) throws FilemanagerException {
        DataSet dataSet = this.data.get(category);
        if (dataSet != null) {
            return dataSet.b64Hash;
        }
        return null;
    }

    @Override
    public InputStream getFile(String category, String id) throws FilemanagerException {
        DataSet dataSet = this.data.get(category);
        if (dataSet != null) {
            return new ByteArrayInputStream(dataSet.data);
        }
        return null;
    }

    @Override
    public void deleteFile(String category, String id) throws FilemanagerException {
        DataSet dataSet = this.data.get(category);
        if (dataSet != null && dataSet.b64Hash.equals(id)) {
            this.data.remove(category);
        }
    }

    @Override
    public String getFileURLBase() {
        return "";
    }

    @Override
    public String getFileExternalURLBase() {
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T getFile(String category, String id, FileHandler<T> filehandler) throws FilemanagerException {
        DataSet dataSet = this.data.get(category);
        if (dataSet == null) throw new CategoryNotFoundException(category);
        try (ByteArrayInputStream stream = new ByteArrayInputStream(dataSet.data);){
            T t = filehandler.handleFile(stream);
            return t;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new CategoryNotFoundException(category);
    }

    @Override
    public FileInfo getMetadata(String category, String id) throws FilemanagerException {
        return new FileInfo();
    }

    private class DataSet {
        String b64Hash;
        byte[] data;

        private DataSet() {
        }
    }
}

