/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.filemanager.client;

import de.governikus.csc.health.HealthCheckCaller;
import de.governikus.csc.health.HealthCheckClient;
import de.governikus.csc.health.HealthSummary;
import de.governikus.csc.health.PingClient;
import de.governikus.csc.health.PingResponseHandler;
import de.governikus.csl.filemanager.ExceptionMapper;
import de.governikus.csl.filemanager.FileHandler;
import de.governikus.csl.filemanager.FileHandlerException;
import de.governikus.csl.filemanager.FilemanagerException;
import de.governikus.csl.filemanager.JSONBindingResponseHandler;
import de.governikus.csl.filemanager.SimpleRESTClient;
import de.governikus.csl.filemanager.URIBuilder;
import de.governikus.csl.filemanager.client.FileManagerClient;
import de.governikus.csl.filemanager.client.FileManagerClientBuilder;
import de.governikus.csl.filemanager.client.FileManagerClientRESTBuilder;
import de.governikus.csl.filemanager.fileinfo.FileInfo;
import de.governikus.csl.filemanager.fileinfo.FolderInfo;
import de.governikus.csl.transport.HttpClient;
import de.governikus.csl.transport.HttpHeader;
import de.governikus.csl.transport.HttpRequest;
import de.governikus.csl.transport.HttpResponseHandler;
import de.governikus.csl.transport.StringResponseHandler;
import de.governikus.csl.transport.entity.InputStreamRequest;
import de.governikus.csl.transport.exception.ResponseException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileManagerClientImplREST
extends SimpleRESTClient
implements FileManagerClient,
HealthCheckClient,
PingClient {
    private static final Logger LOG = LoggerFactory.getLogger(FileManagerClientImplREST.class);
    private static final String RESOURCES_PATH = "resources/";
    protected URIBuilder baseUriBuilder;
    private JSONBindingResponseHandler<FolderInfo> folderInfoResponseHandler;
    private JSONBindingResponseHandler<FileInfo> fileInfoResponseHandler;
    private HttpResponseHandler<HealthSummary> healthResponseHandler;
    private HttpHeader acceptJSONHeader;

    public FileManagerClientImplREST(URI baseURI, HttpClient client, HttpResponseHandler<HealthSummary> healthResponseHandler) {
        super(client);
        this.baseUriBuilder = new URIBuilder(baseURI);
        this.healthResponseHandler = healthResponseHandler;
        this.init();
    }

    public FileManagerClientImplREST(URI baseURI, HttpClient client) {
        super(client);
        this.baseUriBuilder = new URIBuilder(baseURI);
        this.init();
    }

    public FileManagerClientImplREST(URI baseURI) {
        this.baseUriBuilder = new URIBuilder(baseURI);
        this.init();
    }

    private void init() {
        this.folderInfoResponseHandler = new JSONBindingResponseHandler<FolderInfo>(FolderInfo.class);
        this.fileInfoResponseHandler = new JSONBindingResponseHandler<FileInfo>(FileInfo.class);
        this.acceptJSONHeader = new HttpHeader("Accept", "application/json");
    }

    @Override
    public void addFile(String category, InputStream is) throws FilemanagerException {
        URI uri = this.baseUriBuilder.clone().path("saveFile/" + category).build();
        this.handleHttpCall(() -> {
            this.put(uri, (HttpRequest)new InputStreamRequest(is, "application/octet-stream", null), new HttpHeader[0]);
            return null;
        }, category, null);
    }

    @Override
    public List<String> getList(String category) throws FilemanagerException {
        URI uri = this.baseUriBuilder.clone().path(RESOURCES_PATH + category).build();
        FolderInfo folderInfo = this.handleHttpCall(() -> this.get(uri, this.folderInfoResponseHandler, this.acceptJSONHeader), category, null);
        ArrayList<String> result = new ArrayList<String>();
        List<FileInfo> contents = folderInfo.getContents();
        for (FileInfo content : contents) {
            result.add(content.getName());
        }
        return result;
    }

    @Override
    public String getDefault(String category) throws FilemanagerException {
        URI uri = this.baseUriBuilder.clone().path("default/" + category).build();
        FileInfo fileInfo = this.handleHttpCall(() -> this.get(uri, this.fileInfoResponseHandler, this.acceptJSONHeader), category, null);
        return fileInfo == null ? null : fileInfo.getName();
    }

    @Override
    public InputStream getFile(String category, String id) throws FilemanagerException {
        URI uri = this.baseUriBuilder.clone().path(RESOURCES_PATH + category + "/" + id).build();
        return this.handleHttpCall(() -> this.getAsStream(uri, new HttpHeader[0]), category, id);
    }

    @Override
    public void deleteFile(String category, String id) throws FilemanagerException {
        URI uri = this.baseUriBuilder.clone().path("deleteFile/" + category + "/" + id).build();
        this.handleHttpCall(() -> {
            this.delete(uri, new HttpHeader[0]);
            return null;
        }, category, id);
    }

    @Override
    public String getFileURLBase() {
        URI uri = this.baseUriBuilder.clone().path("resources").build();
        return uri.toString();
    }

    @Override
    public String getFileExternalURLBase() {
        URI uri = this.baseUriBuilder.clone().path("externalURL").build();
        try {
            String response = (String)this.get(uri, new StringResponseHandler(), new HttpHeader[0]);
            if (response != null && !response.isEmpty()) {
                URIBuilder uriBuilder = new URIBuilder(response);
                uriBuilder.path("resources");
                return uriBuilder.build().toString();
            }
        }
        catch (IOException e) {
            LOG.error("Couldn't send request successfully: {}", (Object)e.getMessage(), (Object)e);
        }
        return "";
    }

    protected <T> T handleHttpCall(HttpExecutor<T> executor, String category, String resource) throws FilemanagerException {
        try {
            return executor.call();
        }
        catch (ResponseException e) {
            throw ExceptionMapper.mapResponseException(e, category, resource);
        }
        catch (IOException e) {
            throw ExceptionMapper.mapIOException(e);
        }
    }

    @Override
    public <T> T getFile(String category, String id, FileHandler<T> filehandler) throws FilemanagerException {
        URI uri = this.baseUriBuilder.clone().path(RESOURCES_PATH + category + "/" + id).build();
        return (T)this.handleHttpCall(() -> this.downloadAndHandle(uri, filehandler), category, id);
    }

    private <T> T downloadAndHandle(URI uri, FileHandler<T> fh) throws FileHandlerException, IOException {
        try (InputStream is = this.getAsStream(uri, new HttpHeader[0]);){
            T t = fh.handleFile(is);
            return t;
        }
    }

    @Override
    public FileInfo getMetadata(String category, String id) throws FilemanagerException {
        URI uri = this.baseUriBuilder.clone().path(RESOURCES_PATH + category + "/" + id + "/metadata").build();
        FileInfo fileInfo = this.handleHttpCall(() -> this.get(uri, this.fileInfoResponseHandler, this.acceptJSONHeader), category, null);
        return fileInfo == null ? null : fileInfo;
    }

    public HealthSummary checkHealth() throws IOException {
        if (this.healthResponseHandler == null) {
            return HealthCheckCaller.checkHealth((HttpClient)this.client, (URI)this.baseUriBuilder.clone().path("health").build());
        }
        return HealthCheckCaller.checkHealth((HttpClient)this.client, (URI)this.baseUriBuilder.clone().path("health").build(), this.healthResponseHandler);
    }

    public void pingService() throws IOException {
        this.client.get(this.baseUriBuilder.clone().path("health").path("ping").build(), (HttpResponseHandler)new PingResponseHandler(), new HttpHeader[0]);
    }

    @NonNull
    public static FileManagerClientBuilder builder() {
        return new FileManagerClientRESTBuilder();
    }

    private static interface HttpExecutor<T> {
        public T call() throws IOException, FileHandlerException;
    }
}

