/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.filemanager.client;

import de.governikus.csl.filemanager.client.FileManagerClient;
import de.governikus.csl.filemanager.client.FileManagerClientBuilder;
import de.governikus.csl.transport.ApacheHttpClient;
import de.governikus.csl.transport.HttpClient;
import de.governikus.csl.transport.TransportFactoryConfiguration;
import de.governikus.csl.uom.configuration.ProxyConfiguration;
import de.governikus.csl.uom.configuration.ProxyConfigurationImpl;
import de.governikus.csl.utils.CryptoProviderUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;

public abstract class AbstractFileManagerClientBuilder<T extends AbstractFileManagerClientBuilder<T>>
implements FileManagerClientBuilder {
    private URI serverUri;
    private String serverUrl;
    private HttpClient httpClient;
    private TransportFactoryConfiguration transportFactoryConfiguration;
    private int maxConnectionsPerHost = 2;
    private int socketTimeout = 30000;
    private int connectionTimeout = 15000;
    private int connectionManagerTimeout = 60000;
    private ProxyConfiguration proxyConfiguration;
    private List<String> certFileNameList = new ArrayList<String>();
    private List<X509Certificate> certList = new ArrayList<X509Certificate>();
    private List<byte[]> certByteArrayList = new ArrayList<byte[]>();
    private List<InputStream> certInputStreamList = new ArrayList<InputStream>();

    @NonNull
    public T url(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.serverUrl = url;
        return (T)this;
    }

    @NonNull
    public T uri(@NonNull URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        this.serverUri = uri;
        return (T)this;
    }

    @NonNull
    public T sslCert(@NonNull X509Certificate cert) {
        if (cert == null) {
            throw new NullPointerException("cert is marked non-null but is null");
        }
        if (!this.certList.contains(cert)) {
            this.certList.add(cert);
        }
        return (T)this;
    }

    @NonNull
    public T sslCertList(@NonNull List<X509Certificate> certList) {
        if (certList == null) {
            throw new NullPointerException("certList is marked non-null but is null");
        }
        this.certList = certList;
        return (T)this;
    }

    @NonNull
    public T sslCertFileList(@NonNull List<String> certFileNameList) {
        if (certFileNameList == null) {
            throw new NullPointerException("certFileNameList is marked non-null but is null");
        }
        this.certFileNameList = certFileNameList;
        return (T)this;
    }

    @NonNull
    public T sslCert(@NonNull String certFileName) {
        if (certFileName == null) {
            throw new NullPointerException("certFileName is marked non-null but is null");
        }
        if (!this.certFileNameList.contains(certFileName)) {
            this.certFileNameList.add(certFileName);
        }
        return (T)this;
    }

    @NonNull
    public T sslCertByteArrayList(@NonNull List<byte[]> certByteArrayList) {
        if (certByteArrayList == null) {
            throw new NullPointerException("certByteArrayList is marked non-null but is null");
        }
        this.certByteArrayList = certByteArrayList;
        return (T)this;
    }

    @NonNull
    public T sslCert(byte[] cert) {
        if (!this.certByteArrayList.contains(cert)) {
            this.certByteArrayList.add(cert);
        }
        return (T)this;
    }

    @NonNull
    public T sslCertInputStreamList(@NonNull List<InputStream> certInputStreamList) {
        if (certInputStreamList == null) {
            throw new NullPointerException("certInputStreamList is marked non-null but is null");
        }
        this.certInputStreamList = certInputStreamList;
        return (T)this;
    }

    @NonNull
    public T sslCert(@NonNull InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        if (!this.certInputStreamList.contains(inputStream)) {
            this.certInputStreamList.add(inputStream);
        }
        return (T)this;
    }

    @NonNull
    public T httpClient(@NonNull HttpClient httpClient) {
        if (httpClient == null) {
            throw new NullPointerException("httpClient is marked non-null but is null");
        }
        this.httpClient = httpClient;
        return (T)this;
    }

    @NonNull
    public T transportFactoryConfiguration(@NonNull TransportFactoryConfiguration transportFactoryConfiguration) {
        if (transportFactoryConfiguration == null) {
            throw new NullPointerException("transportFactoryConfiguration is marked non-null but is null");
        }
        this.transportFactoryConfiguration = transportFactoryConfiguration;
        return (T)this;
    }

    @NonNull
    public T maxConnectionsPerHost(int maxConnectionsPerHost) {
        this.maxConnectionsPerHost = maxConnectionsPerHost;
        return (T)this;
    }

    @NonNull
    public T socketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return (T)this;
    }

    @NonNull
    public T connectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return (T)this;
    }

    @NonNull
    public T connectionManagerTimeout(int connectionManagerTimeout) {
        this.connectionManagerTimeout = connectionManagerTimeout;
        return (T)this;
    }

    @NonNull
    public T proxyConfiguration(@NonNull ProxyConfiguration proxyConfiguration) {
        if (proxyConfiguration == null) {
            throw new NullPointerException("proxyConfiguration is marked non-null but is null");
        }
        this.proxyConfiguration = proxyConfiguration;
        return (T)this;
    }

    @Override
    @NonNull
    public abstract FileManagerClient build() throws URISyntaxException, CertificateException, IOException, NoSuchProviderException;

    @NonNull
    protected HttpClient getOrCreateHttpClient() throws CertificateException, IOException, NoSuchProviderException {
        if (this.httpClient != null) {
            return this.httpClient;
        }
        return new ApacheHttpClient(this.getOrCreateConfiguration());
    }

    @NonNull
    protected URI getOrCreateUri() throws URISyntaxException {
        if (this.serverUri == null) {
            this.serverUri = new URI(this.serverUrl);
        }
        return this.serverUri;
    }

    @NonNull
    private TransportFactoryConfiguration getOrCreateConfiguration() throws CertificateException, IOException, NoSuchProviderException {
        if (this.transportFactoryConfiguration == null) {
            this.transportFactoryConfiguration = this.createTransportFactoryConfiguration();
        }
        this.transportFactoryConfiguration.setProxyConfiguration(this.getOrCreateProxyConfiguration());
        this.transportFactoryConfiguration.setTrustedServerCerts(this.getMergedTrustedServerCerts());
        return this.transportFactoryConfiguration;
    }

    private List<Certificate> getMergedTrustedServerCerts() throws CertificateException, IOException, NoSuchProviderException {
        ArrayList<X509Certificate> mergedCertificateList = new ArrayList<X509Certificate>(this.getServerCertificateList());
        if (this.transportFactoryConfiguration != null && this.transportFactoryConfiguration.getTrustedServerCerts() != null) {
            mergedCertificateList.addAll(this.transportFactoryConfiguration.getTrustedServerCerts());
        }
        return mergedCertificateList.stream().distinct().collect(Collectors.toList());
    }

    @NonNull
    private ProxyConfiguration getOrCreateProxyConfiguration() {
        return this.proxyConfiguration != null ? this.proxyConfiguration : new ProxyConfigurationImpl();
    }

    @NonNull
    private TransportFactoryConfiguration createTransportFactoryConfiguration() {
        this.transportFactoryConfiguration = new TransportFactoryConfiguration();
        this.transportFactoryConfiguration.setMaxConnectionsPerHost(this.maxConnectionsPerHost);
        this.transportFactoryConfiguration.setConnectionManagerTimeout(this.connectionManagerTimeout);
        this.transportFactoryConfiguration.setConnectionTimeout(this.connectionTimeout);
        this.transportFactoryConfiguration.setSocketTimeout(this.socketTimeout);
        return this.transportFactoryConfiguration;
    }

    @NonNull
    private List<X509Certificate> getServerCertificateList() throws CertificateException, IOException, NoSuchProviderException {
        ArrayList<X509Certificate> trustedServerCertReturnList = new ArrayList<X509Certificate>(this.certList);
        trustedServerCertReturnList.addAll(this.getTrustedServerCertsFromFiles());
        trustedServerCertReturnList.addAll(this.getTrustedServerCertsFromByteArrays());
        trustedServerCertReturnList.addAll(this.getTrustedServerCertsFromInputStreamList());
        return trustedServerCertReturnList.stream().distinct().collect(Collectors.toList());
    }

    @NonNull
    private List<X509Certificate> getTrustedServerCertsFromFiles() throws CertificateException, IOException, NoSuchProviderException {
        ArrayList<X509Certificate> x509CertificateList = new ArrayList<X509Certificate>();
        for (String fileName : this.certFileNameList) {
            x509CertificateList.add(CryptoProviderUtil.loadCert((String)fileName));
        }
        return x509CertificateList;
    }

    @NonNull
    private List<X509Certificate> getTrustedServerCertsFromByteArrays() throws CertificateException, IOException, NoSuchProviderException {
        ArrayList<X509Certificate> x509CertificateList = new ArrayList<X509Certificate>();
        for (byte[] cert : this.certByteArrayList) {
            x509CertificateList.add(CryptoProviderUtil.loadCert((byte[])cert));
        }
        return x509CertificateList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private List<X509Certificate> getTrustedServerCertsFromInputStreamList() throws CertificateException, IOException, NoSuchProviderException {
        ArrayList<X509Certificate> x509CertificateList = new ArrayList<X509Certificate>();
        for (InputStream inputStream : this.certInputStreamList) {
            try {
                x509CertificateList.add(CryptoProviderUtil.loadCert((InputStream)inputStream));
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        return x509CertificateList;
    }
}

