/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.filemanager;

import de.governikus.csl.transport.AbstractHttpClient;
import de.governikus.csl.transport.HttpClient;
import de.governikus.csl.transport.HttpHeader;
import de.governikus.csl.transport.HttpRequest;
import de.governikus.csl.transport.HttpResponse;
import de.governikus.csl.transport.HttpResponseHandler;
import de.governikus.csl.transport.HttpResponseStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;

public class SimpleRESTClient {
    protected HttpClient client;

    public SimpleRESTClient(HttpClient client) {
        this.client = Objects.requireNonNull(client, "");
    }

    protected SimpleRESTClient() {
    }

    protected void setHttpClient(HttpClient client) {
        this.client = client;
    }

    protected <T> T get(URI uri, HttpResponseHandler<T> handler, HttpHeader ... headers) throws IOException {
        return (T)this.client.get(uri, handler, headers);
    }

    protected InputStream getAsStream(URI uri, HttpHeader ... headers) throws IOException {
        HttpResponse httpResponse = null;
        try {
            httpResponse = this.client.get(uri, headers);
            AbstractHttpClient.checkResponseErrors((HttpResponse)httpResponse);
            return new HttpResponseStream(httpResponse, httpResponse.getContent());
        }
        catch (IOException e) {
            if (httpResponse != null) {
                httpResponse.close();
            }
            throw e;
        }
    }

    protected InputStream putAsStream(URI uri, HttpRequest entity, HttpHeader ... headers) throws IOException {
        HttpResponse httpResponse = null;
        try {
            httpResponse = this.client.put(uri, entity, headers);
            AbstractHttpClient.checkResponseErrors((HttpResponse)httpResponse);
            return new HttpResponseStream(httpResponse, httpResponse.getContent());
        }
        catch (IOException e) {
            if (httpResponse != null) {
                httpResponse.close();
            }
            throw e;
        }
    }

    protected void put(URI uri, HttpRequest entity, HttpHeader ... headers) throws IOException {
        try (HttpResponse response = this.client.put(uri, entity, headers);){
            AbstractHttpClient.checkResponseErrors((HttpResponse)response);
        }
    }

    protected <T> T put(URI uri, HttpRequest entity, HttpResponseHandler<T> handler, HttpHeader ... headers) throws IOException {
        return (T)this.client.put(uri, entity, handler, headers);
    }

    protected <T> T post(URI uri, HttpRequest entity, HttpResponseHandler<T> handler, HttpHeader ... headers) throws IOException {
        return (T)this.client.post(uri, entity, handler, headers);
    }

    protected InputStream postAsStream(URI uri, HttpRequest entity, HttpHeader ... headers) throws IOException {
        HttpResponse httpResponse = null;
        try {
            httpResponse = this.client.post(uri, entity, headers);
            AbstractHttpClient.checkResponseErrors((HttpResponse)httpResponse);
            return new HttpResponseStream(httpResponse, httpResponse.getContent());
        }
        catch (IOException e) {
            if (httpResponse != null) {
                httpResponse.close();
            }
            throw e;
        }
    }

    protected void delete(URI uri, HttpHeader ... headers) throws IOException {
        try (HttpResponse response = this.client.delete(uri, headers);){
            AbstractHttpClient.checkResponseErrors((HttpResponse)response);
        }
    }

    public void setAuthToken(String token) {
        this.client.addDefaultHeader("Authorization", "Bearer " + token);
    }
}

