/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.filemanager;

import de.governikus.csl.filemanager.FilemanagerException;
import de.governikus.csl.filemanager.FilemanagerExceptionReason;
import java.util.Objects;

public class ResourceNotFoundException
extends FilemanagerException
implements Comparable<FilemanagerException> {
    private static final long serialVersionUID = -1810796430250277036L;
    private String category;
    private String resource;

    public ResourceNotFoundException(String category, String resource) {
        super(FilemanagerExceptionReason.RESOURCE_NOT_FOUND, "Can't find resource with identifier \"" + resource + "\" in category \"" + category + "\"");
        this.category = category;
        this.resource = resource;
    }

    public ResourceNotFoundException(String category, String resource, Exception cause) {
        super(FilemanagerExceptionReason.RESOURCE_NOT_FOUND, "Can't find resource with identifier \"" + resource + "\" in category \"" + category + "\"", cause);
        this.category = category;
        this.resource = resource;
    }

    public ResourceNotFoundException(String message, String category, String resource) {
        super(FilemanagerExceptionReason.RESOURCE_NOT_FOUND, message);
        this.category = category;
        this.resource = resource;
    }

    public String getCategory() {
        return this.category;
    }

    public String getResource() {
        return this.resource;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hash(this.category) + Objects.hash(this.resource);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceNotFoundException other = (ResourceNotFoundException)obj;
        return Objects.equals(this.category, other.category) && Objects.equals(this.resource, other.resource);
    }

    @Override
    public int compareTo(FilemanagerException other) {
        if (other instanceof ResourceNotFoundException) {
            int c = super.compareTo(other);
            if (c == 0) {
                c = this.category.compareTo(((ResourceNotFoundException)other).getCategory());
            }
            if (c == 0) {
                c = this.resource.compareTo(((ResourceNotFoundException)other).getResource());
            }
            return c;
        }
        return -1;
    }
}

