/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.filemanager;

import de.governikus.csl.filemanager.CategoryNotFoundException;
import de.governikus.csl.filemanager.FilemanagerConnectionException;
import de.governikus.csl.filemanager.FilemanagerException;
import de.governikus.csl.filemanager.FilemanagerExceptionReason;
import de.governikus.csl.filemanager.ResourceNotFoundException;
import de.governikus.csl.transport.exception.ConnectionException;
import de.governikus.csl.transport.exception.ResponseException;
import java.io.IOException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLHandshakeException;

public final class ExceptionMapper {
    private static final String MSG_PROXY_AUTH_ERR = "No or wrong proxy credentials provided!";
    private static final String MSG_FM_NOT_RDY = "The Filemanager service is currently not available!";

    private ExceptionMapper() {
    }

    public static FilemanagerException mapResponseException(ResponseException e, String category, String resource) {
        int status = e.getStatus();
        if (status == 404) {
            if (resource == null) {
                return new CategoryNotFoundException(category);
            }
            return new ResourceNotFoundException(category, resource);
        }
        if (status == 503) {
            return new FilemanagerException(FilemanagerExceptionReason.FILEMANAGER_NOT_READY, MSG_FM_NOT_RDY);
        }
        if (status == 407) {
            return new FilemanagerException(FilemanagerExceptionReason.AUTHENTICATION_ERROR, MSG_PROXY_AUTH_ERR);
        }
        return new FilemanagerException(FilemanagerExceptionReason.SERVER_ERROR, (Exception)((Object)e));
    }

    public static FilemanagerException mapResponseException(ResponseException e) {
        int status = e.getStatus();
        if (status == 404) {
            return new FilemanagerException(FilemanagerExceptionReason.RESOURCE_NOT_FOUND, "Can't find the required resource!");
        }
        if (status == 503) {
            return new FilemanagerException(FilemanagerExceptionReason.FILEMANAGER_NOT_READY, MSG_FM_NOT_RDY);
        }
        if (status == 407) {
            return new FilemanagerException(FilemanagerExceptionReason.AUTHENTICATION_ERROR, MSG_PROXY_AUTH_ERR);
        }
        return new FilemanagerException(FilemanagerExceptionReason.SERVER_ERROR, (Exception)((Object)e));
    }

    public static FilemanagerException mapIOException(IOException e) {
        if (e instanceof SSLHandshakeException || e.getCause() instanceof SSLHandshakeException) {
            return new FilemanagerConnectionException(FilemanagerExceptionReason.SSL_ERROR, "The SSL connection is most likely configured incorrectly! Please check the client and server configurations for mismatches!");
        }
        if (e instanceof UnknownHostException || e.getCause() instanceof UnknownHostException) {
            return new FilemanagerConnectionException(FilemanagerExceptionReason.CONNECTION_ERROR, "The filemanager DNS name cannot be resolved!");
        }
        if (e instanceof ConnectionException || e.getCause() instanceof ConnectionException) {
            return new FilemanagerConnectionException(FilemanagerExceptionReason.CONNECTION_ERROR, "Can't connect to the Filemanager!", e);
        }
        return new FilemanagerException(FilemanagerExceptionReason.INTERNAL_ERROR, e);
    }
}

