/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.filemanager;

import de.governikus.csl.filemanager.FilemanagerException;
import de.governikus.csl.filemanager.FilemanagerExceptionReason;
import java.util.Objects;

public class CategoryNotFoundException
extends FilemanagerException
implements Comparable<FilemanagerException> {
    private static final long serialVersionUID = 1176364768710585399L;
    private String category;

    public CategoryNotFoundException(String category) {
        super(FilemanagerExceptionReason.CATEGORY_NOT_FOUND, "Can't find category " + category);
        this.category = category;
    }

    public String getCategory() {
        return this.category;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hash(this.category);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CategoryNotFoundException other = (CategoryNotFoundException)obj;
        return Objects.equals(this.category, other.category);
    }

    @Override
    public int compareTo(FilemanagerException other) {
        if (other instanceof CategoryNotFoundException) {
            int c = super.compareTo(other);
            if (c == 0) {
                c = this.category.compareTo(((CategoryNotFoundException)other).getCategory());
            }
            return c;
        }
        return -1;
    }
}

