/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.jades.util;

import de.governikus.csl.uom.validate.commons.SignatureValidationDataAttachment;
import java.security.cert.CRL;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bouncycastle.cert.ocsp.OCSPResp;

public class TimestampValidationData {
    private int etisUIndex;
    private Set<SignatureValidationDataAttachment<X509Certificate>> certificates = new HashSet<SignatureValidationDataAttachment<X509Certificate>>();
    private List<SignatureValidationDataAttachment<OCSPResp>> ocspResponses = new ArrayList<SignatureValidationDataAttachment<OCSPResp>>();
    private List<SignatureValidationDataAttachment<CRL>> crls = new ArrayList<SignatureValidationDataAttachment<CRL>>();

    public TimestampValidationData(int etisUIndex, Set<SignatureValidationDataAttachment<X509Certificate>> certificates, List<SignatureValidationDataAttachment<OCSPResp>> ocspResponses, List<SignatureValidationDataAttachment<CRL>> crls) {
        this.etisUIndex = etisUIndex;
        this.addNonNullAttachments(certificates, ocspResponses, crls);
    }

    public TimestampValidationData(int etisUIndex, TimestampValidationData toBeExtended, Set<SignatureValidationDataAttachment<X509Certificate>> newCerts, List<SignatureValidationDataAttachment<OCSPResp>> newOcsps, List<SignatureValidationDataAttachment<CRL>> newCrls) {
        this(etisUIndex, toBeExtended.getCertificates(), toBeExtended.getOcspResponses(), toBeExtended.getCrls());
        if (newCerts != null) {
            this.addNewNonNullCertAttachments(newCerts);
        }
        if (newOcsps != null) {
            this.addNewNonNullOcspAttachments(newOcsps);
        }
        if (newCrls != null) {
            this.addNewNonNullCrlAttachments(newCrls);
        }
    }

    private void addNonNullCertAttachments(Set<SignatureValidationDataAttachment<X509Certificate>> certificates) {
        if (certificates != null) {
            Iterator<SignatureValidationDataAttachment<X509Certificate>> certIt = certificates.iterator();
            while (certIt.hasNext()) {
                SignatureValidationDataAttachment<X509Certificate> nextCert = certIt.next();
                if (nextCert != null && nextCert.getValue() != null) continue;
                certIt.remove();
            }
            certificates.stream().forEach(this.certificates::add);
        }
    }

    private void addNonNullOcspAttachments(List<SignatureValidationDataAttachment<OCSPResp>> ocspResponses) {
        if (ocspResponses != null) {
            Iterator<SignatureValidationDataAttachment<OCSPResp>> ocspIt = ocspResponses.iterator();
            while (ocspIt.hasNext()) {
                SignatureValidationDataAttachment<OCSPResp> nextOcsp = ocspIt.next();
                if (nextOcsp != null && nextOcsp.getValue() != null) continue;
                ocspIt.remove();
            }
            ocspResponses.stream().forEach(this.ocspResponses::add);
        }
    }

    private void addNonNullCrlAttachments(List<SignatureValidationDataAttachment<CRL>> crls) {
        if (crls != null) {
            Iterator<SignatureValidationDataAttachment<CRL>> crlIt = crls.iterator();
            while (crlIt.hasNext()) {
                SignatureValidationDataAttachment<CRL> nextCrl = crlIt.next();
                if (nextCrl != null && nextCrl.getValue() != null) continue;
                crlIt.remove();
            }
            crls.stream().forEach(this.crls::add);
        }
    }

    private void addNonNullAttachments(Set<SignatureValidationDataAttachment<X509Certificate>> certificates, List<SignatureValidationDataAttachment<OCSPResp>> ocspResponses, List<SignatureValidationDataAttachment<CRL>> crls) {
        this.addNonNullCertAttachments(certificates);
        this.addNonNullOcspAttachments(ocspResponses);
        this.addNonNullCrlAttachments(crls);
    }

    private void addNewNonNullCertAttachments(Set<SignatureValidationDataAttachment<X509Certificate>> certsToAdd) {
        HashSet<SignatureValidationDataAttachment<X509Certificate>> removeList = new HashSet<SignatureValidationDataAttachment<X509Certificate>>();
        for (SignatureValidationDataAttachment<X509Certificate> newAttachment : certsToAdd) {
            if (newAttachment == null) {
                removeList.add(newAttachment);
                continue;
            }
            byte[] newEnc = this.getEncodedValue(newAttachment);
            if (newEnc.length == 0) {
                removeList.add(newAttachment);
                continue;
            }
            for (SignatureValidationDataAttachment<X509Certificate> existingAttachment : this.certificates) {
                byte[] existingEnc = this.getEncodedValue(existingAttachment);
                if (!Arrays.equals(existingEnc, newEnc)) continue;
                removeList.add(newAttachment);
            }
        }
        certsToAdd.removeAll(removeList);
        certsToAdd.stream().forEach(this.certificates::add);
    }

    private void addNewNonNullOcspAttachments(List<SignatureValidationDataAttachment<OCSPResp>> ocspsToAdd) {
        HashSet<SignatureValidationDataAttachment<OCSPResp>> removeList = new HashSet<SignatureValidationDataAttachment<OCSPResp>>();
        for (SignatureValidationDataAttachment<OCSPResp> newAttachment : ocspsToAdd) {
            if (newAttachment == null) {
                removeList.add(newAttachment);
                continue;
            }
            byte[] newEnc = this.getEncodedValue(newAttachment);
            if (newEnc.length == 0) {
                removeList.add(newAttachment);
                continue;
            }
            for (SignatureValidationDataAttachment<OCSPResp> existingAttachment : this.ocspResponses) {
                byte[] existingEnc = this.getEncodedValue(existingAttachment);
                if (!Arrays.equals(existingEnc, newEnc)) continue;
                removeList.add(newAttachment);
            }
        }
        ocspsToAdd.removeAll(removeList);
        ocspsToAdd.stream().forEach(this.ocspResponses::add);
    }

    private void addNewNonNullCrlAttachments(List<SignatureValidationDataAttachment<CRL>> crlsToAdd) {
        HashSet<SignatureValidationDataAttachment<CRL>> removeList = new HashSet<SignatureValidationDataAttachment<CRL>>();
        for (SignatureValidationDataAttachment<CRL> newAttachment : crlsToAdd) {
            if (newAttachment == null) {
                removeList.add(newAttachment);
                continue;
            }
            byte[] newEnc = this.getEncodedValue(newAttachment);
            if (newEnc.length == 0) {
                removeList.add(newAttachment);
                continue;
            }
            for (SignatureValidationDataAttachment<CRL> existingAttachment : this.crls) {
                byte[] existingEnc = this.getEncodedValue(existingAttachment);
                if (!Arrays.equals(existingEnc, newEnc)) continue;
                removeList.add(newAttachment);
            }
        }
        crlsToAdd.removeAll(removeList);
        crlsToAdd.stream().forEach(this.crls::add);
    }

    private <A, SVDA extends SignatureValidationDataAttachment<A>> byte[] getEncodedValue(SVDA svda) {
        if (svda == null) {
            return new byte[0];
        }
        Object value = svda.getValue();
        if (value == null) {
            return new byte[0];
        }
        try {
            if (value instanceof X509Certificate) {
                return ((X509Certificate)value).getEncoded();
            }
            if (value instanceof OCSPResp) {
                return ((OCSPResp)value).getEncoded();
            }
            if (value instanceof CRL) {
                return ((X509CRL)value).getEncoded();
            }
        }
        catch (Exception e) {
            return new byte[0];
        }
        return new byte[0];
    }

    public int getEtsiUIndex() {
        return this.etisUIndex;
    }

    public Set<SignatureValidationDataAttachment<X509Certificate>> getCertificates() {
        return this.certificates;
    }

    public List<SignatureValidationDataAttachment<OCSPResp>> getOcspResponses() {
        return this.ocspResponses;
    }

    public List<SignatureValidationDataAttachment<CRL>> getCrls() {
        return this.crls;
    }
}

